/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarTestUtils;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRowBlockFieldExtraction {
    @Test
    public void testBlockFieldExtraction() {
        int fieldCount = 5;
        RowType rowType = RowType.anonymous(Collections.nCopies(fieldCount, VarcharType.VARCHAR));
        Slice[][] expectedValues = new Slice[20][];
        for (int rowIndex = 0; rowIndex < expectedValues.length; ++rowIndex) {
            expectedValues[rowIndex] = new Slice[fieldCount];
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                if (fieldIndex % 3 == 1) continue;
                expectedValues[rowIndex][fieldIndex] = Slices.utf8Slice((String)String.format("%d.%d", rowIndex, fieldIndex));
            }
        }
        Block block = TestRowBlockFieldExtraction.createBlockBuilderWithValues(rowType, expectedValues);
        TestRowBlockFieldExtraction.verifyBlock(rowType, block, expectedValues);
        Slice[][] expectedValuesWithNull = (Slice[][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        Block blockWithNull = TestRowBlockFieldExtraction.createBlockBuilderWithValues(rowType, expectedValuesWithNull);
        TestRowBlockFieldExtraction.verifyBlock(rowType, blockWithNull, expectedValuesWithNull);
    }

    private static <T> void verifyBlock(RowType rowType, Block block, T[] expectedValues) {
        ColumnarTestUtils.assertBlock((Type)rowType, block, expectedValues);
        TestRowBlockFieldExtraction.assertGetFields(rowType, block, expectedValues);
        TestRowBlockFieldExtraction.assertGetNullSuppressedFields(rowType, block, expectedValues);
        TestRowBlockFieldExtraction.assertDictionaryBlock(rowType, block, expectedValues);
        TestRowBlockFieldExtraction.assertRunLengthEncodedBlock(rowType, block, expectedValues);
        int offset = 1;
        int length = expectedValues.length - 2;
        Block blockRegion = block.getRegion(offset, length);
        T[] expectedValuesRegion = Arrays.copyOfRange(expectedValues, offset, offset + length);
        ColumnarTestUtils.assertBlock((Type)rowType, blockRegion, expectedValuesRegion);
        TestRowBlockFieldExtraction.assertGetFields(rowType, blockRegion, expectedValuesRegion);
        TestRowBlockFieldExtraction.assertGetNullSuppressedFields(rowType, blockRegion, expectedValuesRegion);
        TestRowBlockFieldExtraction.assertDictionaryBlock(rowType, blockRegion, expectedValuesRegion);
        TestRowBlockFieldExtraction.assertRunLengthEncodedBlock(rowType, blockRegion, expectedValuesRegion);
    }

    private static <T> void assertDictionaryBlock(RowType rowType, Block block, T[] expectedValues) {
        Block dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        T[] expectedDictionaryValues = ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock((Type)rowType, dictionaryBlock, expectedDictionaryValues);
        TestRowBlockFieldExtraction.assertGetFields(rowType, dictionaryBlock, expectedDictionaryValues);
        TestRowBlockFieldExtraction.assertGetNullSuppressedFields(rowType, dictionaryBlock, expectedDictionaryValues);
        TestRowBlockFieldExtraction.assertRunLengthEncodedBlock(rowType, dictionaryBlock, expectedDictionaryValues);
    }

    private static <T> void assertRunLengthEncodedBlock(RowType rowType, Block block, T[] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            T[] expectedDictionaryValues = ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Type)rowType, (Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestRowBlockFieldExtraction.assertGetFields(rowType, (Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestRowBlockFieldExtraction.assertGetNullSuppressedFields(rowType, (Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static <T> void assertGetFields(RowType rowType, Block block, T[] expectedValues) {
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedValues.length);
        List nullSuppressedFields = RowBlock.getRowFieldsFromBlock((Block)block);
        for (int fieldId = 0; fieldId < 5; ++fieldId) {
            Block fieldBlock = (Block)nullSuppressedFields.get(fieldId);
            Type fieldType = (Type)rowType.getTypeParameters().get(fieldId);
            for (int position = 0; position < expectedValues.length; ++position) {
                T expectedRow = expectedValues[position];
                Assertions.assertThat((boolean)block.isNull(position)).isEqualTo(expectedRow == null);
                Object expectedElement = expectedRow == null ? null : Array.get(expectedRow, fieldId);
                ColumnarTestUtils.assertBlockPosition(fieldType, fieldBlock, position, expectedElement);
            }
        }
    }

    private static <T> void assertGetNullSuppressedFields(RowType rowType, Block block, T[] expectedValues) {
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedValues.length);
        List nullSuppressedFields = RowBlock.getNullSuppressedRowFieldsFromBlock((Block)block);
        for (int fieldId = 0; fieldId < 5; ++fieldId) {
            Block fieldBlock = (Block)nullSuppressedFields.get(fieldId);
            Type fieldType = (Type)rowType.getTypeParameters().get(fieldId);
            int nullSuppressedPosition = 0;
            for (int position = 0; position < expectedValues.length; ++position) {
                T expectedRow = expectedValues[position];
                Assertions.assertThat((boolean)block.isNull(position)).isEqualTo(expectedRow == null);
                if (expectedRow == null) continue;
                Object expectedElement = Array.get(expectedRow, fieldId);
                ColumnarTestUtils.assertBlockPosition(fieldType, fieldBlock, nullSuppressedPosition, expectedElement);
                ++nullSuppressedPosition;
            }
        }
    }

    public static Block createBlockBuilderWithValues(RowType rowType, Slice[][] expectedValues) {
        RowBlockBuilder blockBuilder = rowType.createBlockBuilder(null, 100);
        for (Slice[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry(fieldBuilders -> {
                for (int i = 0; i < expectedValue.length; ++i) {
                    Slice v = expectedValue[i];
                    if (v == null) {
                        ((BlockBuilder)fieldBuilders.get(i)).appendNull();
                        continue;
                    }
                    VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(i), v);
                }
            });
        }
        return blockBuilder.build();
    }
}

