/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ShortArrayBlock;
import io.trino.spi.block.ShortArrayBlockBuilder;
import io.trino.spi.block.ValueBlock;
import java.util.ArrayList;
import java.util.List;

public class TestShortArrayBlockBuilder
extends AbstractTestBlockBuilder<Short> {
    @Override
    protected BlockBuilder createBlockBuilder() {
        return new ShortArrayBlockBuilder(null, 1);
    }

    @Override
    protected List<Short> getTestValues() {
        return List.of(Short.valueOf((short)10), Short.valueOf((short)11), Short.valueOf((short)12), Short.valueOf((short)13), Short.valueOf((short)14));
    }

    @Override
    protected Short getUnusedTestValue() {
        return (short)-1;
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<Short> values) {
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, 1);
        for (Short value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeShort(value.shortValue());
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<Short> blockToValues(ValueBlock valueBlock) {
        ShortArrayBlock shortArrayBlock = (ShortArrayBlock)valueBlock;
        ArrayList<Short> actualValues = new ArrayList<Short>(shortArrayBlock.getPositionCount());
        for (int i = 0; i < shortArrayBlock.getPositionCount(); ++i) {
            if (shortArrayBlock.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            actualValues.add(shortArrayBlock.getShort(i));
        }
        return actualValues;
    }
}

