/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slices;
import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVariableWidthBlockBuilder
extends AbstractTestBlockBuilder<String> {
    private static final int BLOCK_BUILDER_INSTANCE_SIZE = SizeOf.instanceSize(VariableWidthBlockBuilder.class);
    private static final int VARCHAR_VALUE_SIZE = 7;
    private static final int VARCHAR_ENTRY_SIZE = 11;
    private static final int EXPECTED_ENTRY_COUNT = 3;

    @Test
    public void testFixedBlockIsFull() {
        this.testIsFull(new PageBuilderStatus(33));
    }

    @Test
    public void testNewBlockBuilderLike() {
        int entries = 12345;
        double resetSkew = 1.25;
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, entries, entries);
        for (int i = 0; i < entries; ++i) {
            blockBuilder.writeEntry(Slices.wrappedBuffer((byte[])new byte[]{(byte)i}));
        }
        blockBuilder = (VariableWidthBlockBuilder)blockBuilder.newBlockBuilderLike(null);
        blockBuilder.writeEntry(Slices.wrappedBuffer((byte[])new byte[]{1}));
        long actualArraySize = SizeOf.sizeOf((int[])new int[(int)Math.ceil(resetSkew * (double)(entries + 1))]) + SizeOf.sizeOf((boolean[])new boolean[(int)Math.ceil(resetSkew * (double)entries)]);
        long actualBytesSize = SizeOf.sizeOf((byte[])new byte[(int)Math.ceil(resetSkew * (double)entries)]);
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo((long)BLOCK_BUILDER_INSTANCE_SIZE + actualBytesSize + actualArraySize);
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(pageBuilderStatus.createBlockBuilderStatus(), 32, 1024);
        Assertions.assertThat((boolean)pageBuilderStatus.isEmpty()).isTrue();
        while (!pageBuilderStatus.isFull()) {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, Slices.allocate((int)7));
        }
        Assertions.assertThat((int)blockBuilder.getPositionCount()).isEqualTo(3);
        Assertions.assertThat((boolean)pageBuilderStatus.isFull()).isEqualTo(true);
    }

    @Test
    public void testBuilderProducesNullRleForNullRows() {
        TestVariableWidthBlockBuilder.assertIsAllNulls(TestVariableWidthBlockBuilder.blockBuilder().build(), 0);
        TestVariableWidthBlockBuilder.assertIsAllNulls(TestVariableWidthBlockBuilder.blockBuilder().appendNull().build(), 1);
        TestVariableWidthBlockBuilder.assertIsAllNulls(TestVariableWidthBlockBuilder.blockBuilder().appendNull().appendNull().build(), 2);
    }

    @Test
    public void testAppendRepeatedEmpty() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        VariableWidthBlock value = VarcharType.VARCHAR.createBlockBuilder(null, 1).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.EMPTY_SLICE).writeEntry(Slices.utf8Slice((String)"ignored")).buildValueBlock();
        blockBuilder.appendRepeated((ValueBlock)value, 1, 10);
        List<String> strings = TestVariableWidthBlockBuilder.toStrings(blockBuilder.buildValueBlock());
        Assertions.assertThat(strings).isEqualTo(Collections.nCopies(10, ""));
    }

    @Test
    public void testAppendRepeatedSingle() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        VariableWidthBlock value = VarcharType.VARCHAR.createBlockBuilder(null, 1).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"ab")).writeEntry(Slices.utf8Slice((String)"ignored")).buildValueBlock();
        blockBuilder.appendRepeated((ValueBlock)value, 1, 1);
        List<String> strings = TestVariableWidthBlockBuilder.toStrings(blockBuilder.buildValueBlock());
        Assertions.assertThat(strings).isEqualTo((Object)ImmutableList.of((Object)"ab"));
    }

    @Test
    public void testAppendRepeated1Byte() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        VariableWidthBlock value = VarcharType.VARCHAR.createBlockBuilder(null, 1).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"X")).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"Y")).writeEntry(Slices.utf8Slice((String)"ignored")).buildValueBlock();
        blockBuilder.appendRepeated((ValueBlock)value, 1, 3);
        blockBuilder.appendRepeated((ValueBlock)value, 3, 2);
        List<String> strings = TestVariableWidthBlockBuilder.toStrings(blockBuilder.buildValueBlock());
        Assertions.assertThat(strings).isEqualTo((Object)ImmutableList.of((Object)"X", (Object)"X", (Object)"X", (Object)"Y", (Object)"Y"));
    }

    @Test
    public void testAppendRepeated2Bytes() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        VariableWidthBlock value = VarcharType.VARCHAR.createBlockBuilder(null, 1).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"ab")).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"Y")).writeEntry(Slices.utf8Slice((String)"ignored")).buildValueBlock();
        blockBuilder.appendRepeated((ValueBlock)value, 1, 3);
        List<String> strings = TestVariableWidthBlockBuilder.toStrings(blockBuilder.buildValueBlock());
        Assertions.assertThat(strings).isEqualTo((Object)ImmutableList.of((Object)"ab", (Object)"ab", (Object)"ab"));
    }

    @Test
    public void testAppendRepeatedMultipleBytesOddNumberOfTimes() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        VariableWidthBlock value = VarcharType.VARCHAR.createBlockBuilder(null, 1).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"abc")).writeEntry(Slices.utf8Slice((String)"ignored")).buildValueBlock();
        blockBuilder.appendRepeated((ValueBlock)value, 1, 5);
        List<String> strings = TestVariableWidthBlockBuilder.toStrings(blockBuilder.buildValueBlock());
        Assertions.assertThat(strings).isEqualTo(Collections.nCopies(5, "abc"));
    }

    @Test
    public void testAppendRepeatedMultipleBytesEvenNumberOfTimes() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        VariableWidthBlock value = VarcharType.VARCHAR.createBlockBuilder(null, 1).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"abc")).writeEntry(Slices.utf8Slice((String)"ignored")).buildValueBlock();
        blockBuilder.appendRepeated((ValueBlock)value, 1, 6);
        List<String> strings = TestVariableWidthBlockBuilder.toStrings(blockBuilder.buildValueBlock());
        Assertions.assertThat(strings).isEqualTo(Collections.nCopies(6, "abc"));
    }

    @Test
    public void testAppendRepeatedMultipleBytesPowerOf2NumberOfTimes() {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        VariableWidthBlock value = VarcharType.VARCHAR.createBlockBuilder(null, 1).writeEntry(Slices.utf8Slice((String)"ignored")).writeEntry(Slices.utf8Slice((String)"abc")).writeEntry(Slices.utf8Slice((String)"ignored")).buildValueBlock();
        blockBuilder.appendRepeated((ValueBlock)value, 1, 8);
        List<String> strings = TestVariableWidthBlockBuilder.toStrings(blockBuilder.buildValueBlock());
        Assertions.assertThat(strings).isEqualTo(Collections.nCopies(8, "abc"));
    }

    private static BlockBuilder blockBuilder() {
        return new VariableWidthBlockBuilder(null, 10, 0);
    }

    private static void assertIsAllNulls(Block block, int expectedPositionCount) {
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedPositionCount);
        if (expectedPositionCount <= 1) {
            Assertions.assertThat((Class)block.getClass()).isEqualTo(VariableWidthBlock.class);
        } else {
            Assertions.assertThat((Class)block.getClass()).isEqualTo(RunLengthEncodedBlock.class);
            Assertions.assertThat((Class)((RunLengthEncodedBlock)block).getValue().getClass()).isEqualTo(VariableWidthBlock.class);
        }
        if (expectedPositionCount > 0) {
            Assertions.assertThat((boolean)block.isNull(0)).isTrue();
        }
    }

    private static List<String> toStrings(VariableWidthBlock block) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            list.add((Object)VarcharType.VARCHAR.getSlice((Block)block, i).toStringUtf8());
        }
        return list.build();
    }

    @Override
    protected BlockBuilder createBlockBuilder() {
        return new VariableWidthBlockBuilder(null, 1, 100);
    }

    @Override
    protected List<String> getTestValues() {
        return List.of("a", "bb", "cCc", "dddd", "eeEee");
    }

    @Override
    protected String getUnusedTestValue() {
        return "unused";
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<String> values) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 100);
        for (String value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeEntry(Slices.utf8Slice((String)value));
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<String> blockToValues(ValueBlock valueBlock) {
        VariableWidthBlock block = (VariableWidthBlock)valueBlock;
        ArrayList<String> actualValues = new ArrayList<String>(block.getPositionCount());
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            actualValues.add(block.getSlice(i).toStringUtf8());
        }
        return actualValues;
    }
}

