/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestConnectorViewDefinition {
    private static final JsonCodec<ConnectorViewDefinition> CODEC = TestConnectorViewDefinition.createTestingViewCodec();
    private static final String BASE_JSON = "\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}]";

    private static JsonCodec<ConnectorViewDefinition> createTestingViewCodec() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TestingTypeDeserializer(new TestingTypeManager()))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ConnectorViewDefinition.class);
    }

    @Test
    public void testLegacyViewWithoutOwner() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}]}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assertions.assertThat((Optional)view.getOwner()).isNotPresent();
    }

    @Test
    public void testViewWithOwner() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"owner\": \"abc\"}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assertions.assertThat((Optional)view.getOwner()).isEqualTo(Optional.of("abc"));
        Assertions.assertThat((boolean)view.isRunAsInvoker()).isFalse();
    }

    @Test
    public void testViewComment() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"comment\": \"hello\"}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assertions.assertThat((Optional)view.getComment()).isEqualTo(Optional.of("hello"));
    }

    @Test
    public void testViewSecurityDefiner() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"owner\": \"abc\", \"runAsInvoker\": false}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assertions.assertThat((Optional)view.getOwner()).isEqualTo(Optional.of("abc"));
        Assertions.assertThat((boolean)view.isRunAsInvoker()).isFalse();
    }

    @Test
    public void testViewSecurityInvoker() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"runAsInvoker\": true}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assertions.assertThat((Optional)view.getOwner()).isNotPresent();
        Assertions.assertThat((boolean)view.isRunAsInvoker()).isTrue();
    }

    @Test
    public void testRoundTrip() {
        TestConnectorViewDefinition.assertRoundTrip(new ConnectorViewDefinition("test view SQL", Optional.of("test_catalog"), Optional.of("test_schema"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("abc", BigintType.BIGINT.getTypeId(), Optional.of("abc description")), (Object)new ConnectorViewDefinition.ViewColumn("xyz", new ArrayType((Type)VarcharType.createVarcharType((int)32)).getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of("test_owner"), false, (List)ImmutableList.of()));
    }

    private static void assertBaseView(ConnectorViewDefinition view) {
        Assertions.assertThat((String)view.getOriginalSql()).isEqualTo("SELECT 42 x");
        Assertions.assertThat((int)view.getColumns().size()).isEqualTo(1);
        ConnectorViewDefinition.ViewColumn column = (ConnectorViewDefinition.ViewColumn)Iterables.getOnlyElement((Iterable)view.getColumns());
        Assertions.assertThat((String)column.getName()).isEqualTo("x");
        Assertions.assertThat((Object)column.getType()).isEqualTo((Object)BigintType.BIGINT.getTypeId());
        TestConnectorViewDefinition.assertRoundTrip(view);
    }

    private static void assertRoundTrip(ConnectorViewDefinition expected) {
        ConnectorViewDefinition actual = (ConnectorViewDefinition)CODEC.fromJson(CODEC.toJson((Object)expected));
        Assertions.assertThat((Optional)actual.getOwner()).isEqualTo((Object)expected.getOwner());
        Assertions.assertThat((boolean)actual.isRunAsInvoker()).isEqualTo(expected.isRunAsInvoker());
        Assertions.assertThat((Optional)actual.getCatalog()).isEqualTo((Object)expected.getCatalog());
        Assertions.assertThat((Optional)actual.getSchema()).isEqualTo((Object)expected.getSchema());
        Assertions.assertThat((String)actual.getOriginalSql()).isEqualTo(expected.getOriginalSql());
        ((ListAssert)Assertions.assertThat((List)actual.getColumns()).usingElementComparator(TestConnectorViewDefinition.columnComparator())).isEqualTo((Object)expected.getColumns());
    }

    private static Comparator<ConnectorViewDefinition.ViewColumn> columnComparator() {
        return Comparator.comparing(ConnectorViewDefinition.ViewColumn::getName).thenComparing(column -> column.getType().toString());
    }
}

