/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.TestingSession;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InternalDataAccessor;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionAdapter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestScalarFunctionAdapter {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private static final ArrayType ARRAY_TYPE = new ArrayType((Type)BigintType.BIGINT);
    private static final CharType CHAR_TYPE = CharType.createCharType((int)7);
    private static final TimestampType TIMESTAMP_TYPE = TimestampType.createTimestampType((int)9);
    private static final Type RETURN_TYPE = BooleanType.BOOLEAN;
    private static final List<Type> ARGUMENT_TYPES = ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)ARRAY_TYPE);
    private static final List<Type> OBJECTS_ARGUMENT_TYPES = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)ARRAY_TYPE, (Object)CHAR_TYPE, (Object)TIMESTAMP_TYPE);

    @Test
    public void testAdaptFromNeverNull() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "neverNull", RETURN_TYPE, ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptNullableReturnToBlockBuilder() throws Throwable {
        MethodHandle adaptedMethodHandle = ScalarFunctionAdapter.adapt((MethodHandle)MethodHandles.identity(Double.class), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE), (InvocationConvention)InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE}), (InvocationConvention)InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE}));
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        adaptedMethodHandle.invoke(1.1, blockBuilder);
        adaptedMethodHandle.invoke(null, blockBuilder);
        ValueBlock block = blockBuilder.buildValueBlock();
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(2);
        Assertions.assertThat((boolean)block.isNull(0)).isFalse();
        Assertions.assertThat((double)DoubleType.DOUBLE.getDouble((Block)block, 0)).isEqualTo(1.1);
        Assertions.assertThat((boolean)block.isNull(1)).isTrue();
    }

    @Test
    public void testAdaptFromNeverNullObjects() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(OBJECTS_ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "neverNullObjects", RETURN_TYPE, OBJECTS_ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromBoxedNull() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "boxedNull", RETURN_TYPE, ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromBoxedNullObjects() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(OBJECTS_ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "boxedNullObjects", RETURN_TYPE, OBJECTS_ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromNullFlag() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "nullFlag", RETURN_TYPE, ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromNullFlagObjects() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(OBJECTS_ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "nullFlagObjects", RETURN_TYPE, OBJECTS_ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromBlockPosition() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "blockPosition", RETURN_TYPE, ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromBlockPositionObjects() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(OBJECTS_ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "blockPositionObjects", RETURN_TYPE, OBJECTS_ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromBlockPositionNotNull() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "blockPosition", RETURN_TYPE, ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromBlockPositionNotNullObjects() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(OBJECTS_ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, "blockPositionObjects", RETURN_TYPE, OBJECTS_ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromValueBlockPosition() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        String methodName = "valueBlockPosition";
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, RETURN_TYPE, ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromValueBlockPositionObjects() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(OBJECTS_ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        String methodName = "valueBlockPositionObjects";
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, RETURN_TYPE, OBJECTS_ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromValueBlockPositionNotNull() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        String methodName = "valueBlockPosition";
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, RETURN_TYPE, ARGUMENT_TYPES);
    }

    @Test
    public void testAdaptFromValueBlockPositionObjectsNotNull() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(OBJECTS_ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        String methodName = "valueBlockPositionObjects";
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, RETURN_TYPE, OBJECTS_ARGUMENT_TYPES);
    }

    private static void verifyAllAdaptations(InvocationConvention actualConvention, String methodName, Type returnType, List<Type> argumentTypes) throws Throwable {
        MethodType type = MethodType.methodType(actualConvention.getReturnConvention() == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL ? Boolean.TYPE : Boolean.class, TestScalarFunctionAdapter.toCallArgumentTypes(actualConvention, argumentTypes));
        MethodHandle methodHandle = MethodHandles.lookup().findVirtual(Target.class, methodName, type);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodHandle, returnType, argumentTypes);
    }

    private static void verifyAllAdaptations(InvocationConvention actualConvention, MethodHandle methodHandle, Type returnType, List<Type> argumentTypes) throws Throwable {
        List allArgumentConventions = TestScalarFunctionAdapter.allCombinations(ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, (Object)InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, (Object)InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION, (Object)InvocationConvention.InvocationArgumentConvention.FLAT, (Object)InvocationConvention.InvocationArgumentConvention.IN_OUT), argumentTypes.size());
        for (List argumentConventions : allArgumentConventions) {
            for (InvocationConvention.InvocationReturnConvention returnConvention : InvocationConvention.InvocationReturnConvention.values()) {
                InvocationConvention expectedConvention = new InvocationConvention(argumentConventions, returnConvention, false, true);
                TestScalarFunctionAdapter.adaptAndVerify(methodHandle, actualConvention, expectedConvention, returnType, argumentTypes);
            }
        }
    }

    private static void adaptAndVerify(MethodHandle methodHandle, InvocationConvention actualConvention, InvocationConvention expectedConvention, Type returnType, List<Type> argumentTypes) throws Throwable {
        MethodHandle adaptedMethodHandle;
        try {
            adaptedMethodHandle = ScalarFunctionAdapter.adapt((MethodHandle)methodHandle, (Type)returnType, argumentTypes, (InvocationConvention)actualConvention, (InvocationConvention)expectedConvention);
            Assertions.assertThat((boolean)ScalarFunctionAdapter.canAdapt((InvocationConvention)actualConvention, (InvocationConvention)expectedConvention)).isTrue();
        }
        catch (IllegalArgumentException e) {
            if (!ScalarFunctionAdapter.canAdapt((InvocationConvention)actualConvention, (InvocationConvention)expectedConvention)) {
                if (TestScalarFunctionAdapter.hasNullableToNoNullableAdaptation(actualConvention, expectedConvention)) {
                    Assertions.assertThat((expectedConvention.getReturnConvention() == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL || expectedConvention.getReturnConvention() == InvocationConvention.InvocationReturnConvention.FLAT_RETURN ? 1 : 0) != 0).isTrue();
                    return;
                }
                if (actualConvention.getArgumentConventions().stream().anyMatch(convention -> EnumSet.of(InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL).contains(convention))) {
                    return;
                }
            }
            throw new AssertionError("Adaptation failed but no illegal conversions found", e);
        }
        InvocationConvention newCallingConvention = new InvocationConvention(expectedConvention.getArgumentConventions(), expectedConvention.getReturnConvention(), actualConvention.supportsSession(), actualConvention.supportsInstanceFactory());
        MethodHandle exactInvoker = MethodHandles.exactInvoker(adaptedMethodHandle.type()).bindTo(adaptedMethodHandle);
        if (expectedConvention.getReturnConvention() != InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER) {
            exactInvoker = MethodHandles.explicitCastArguments(exactInvoker, exactInvoker.type().changeReturnType(Boolean.class));
        }
        for (int notNullMask = 0; notNullMask < 1 << actualConvention.getArgumentConventions().size(); ++notNullMask) {
            BitSet nullArguments = BitSet.valueOf(new long[]{notNullMask});
            if (!TestScalarFunctionAdapter.canCallConventionWithNullArguments(expectedConvention, nullArguments)) continue;
            Target target = new Target();
            List<Object> argumentValues = TestScalarFunctionAdapter.toCallArgumentValues(newCallingConvention, nullArguments, target, argumentTypes);
            try {
                boolean expectNull = TestScalarFunctionAdapter.expectNullReturn(actualConvention, nullArguments);
                if (expectedConvention.getReturnConvention() == InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER) {
                    BlockBuilder blockBuilder = returnType.createBlockBuilder(null, 1);
                    argumentValues.add(blockBuilder);
                    exactInvoker.invokeWithArguments(argumentValues);
                    Block result = blockBuilder.build();
                    Assertions.assertThat((int)result.getPositionCount()).isEqualTo(1);
                    Assertions.assertThat((boolean)result.isNull(0)).isEqualTo(expectNull);
                    if (!expectNull) {
                        Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(result, 0)).isTrue();
                    }
                    return;
                }
                Boolean result = (Boolean)exactInvoker.invokeWithArguments(argumentValues);
                switch (expectedConvention.getReturnConvention()) {
                    case FAIL_ON_NULL: {
                        Assertions.assertThat((Boolean)result).isTrue();
                        break;
                    }
                    case DEFAULT_ON_NULL: {
                        Assertions.assertThat((Boolean)result).isEqualTo((Object)(!expectNull ? 1 : 0));
                        break;
                    }
                    case NULLABLE_RETURN: {
                        Assertions.assertThat((Boolean)result).isEqualTo((Object)(!expectNull ? Boolean.valueOf(true) : null));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (TrinoException trinoException) {
                Assertions.assertThat((Object)trinoException.getErrorCode()).isEqualTo((Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            }
            target.verify(actualConvention, nullArguments, argumentTypes);
        }
    }

    private static boolean hasNullableToNoNullableAdaptation(InvocationConvention actualConvention, InvocationConvention expectedConvention) {
        for (int i = 0; i < actualConvention.getArgumentConventions().size(); ++i) {
            InvocationConvention.InvocationArgumentConvention actualArgumentConvention = actualConvention.getArgumentConvention(i);
            InvocationConvention.InvocationArgumentConvention expectedArgumentConvention = expectedConvention.getArgumentConvention(i);
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL && (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE || expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG)) {
                return true;
            }
            if (actualArgumentConvention != InvocationConvention.InvocationArgumentConvention.IN_OUT) continue;
            return true;
        }
        return actualConvention.getReturnConvention() != expectedConvention.getReturnConvention() && expectedConvention.getReturnConvention() == InvocationConvention.InvocationReturnConvention.FLAT_RETURN;
    }

    private static boolean canCallConventionWithNullArguments(InvocationConvention convention, BitSet nullArguments) {
        for (int i = 0; i < convention.getArgumentConventions().size(); ++i) {
            InvocationConvention.InvocationArgumentConvention argumentConvention = convention.getArgumentConvention(i);
            if (!nullArguments.get(i) || !EnumSet.of(InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.FLAT).contains(argumentConvention)) continue;
            return false;
        }
        return true;
    }

    private static boolean expectNullReturn(InvocationConvention convention, BitSet nullArguments) {
        for (int i = 0; i < convention.getArgumentConventions().size(); ++i) {
            InvocationConvention.InvocationArgumentConvention argumentConvention = convention.getArgumentConvention(i);
            if (!nullArguments.get(i) || argumentConvention.isNullable()) continue;
            return true;
        }
        return false;
    }

    private static List<Class<?>> toCallArgumentTypes(InvocationConvention callingConvention, List<Type> argumentTypes) {
        ArrayList expectedArguments = new ArrayList();
        block9: for (int i = 0; i < callingConvention.getArgumentConventions().size(); ++i) {
            Type argumentType = argumentTypes.get(i);
            InvocationConvention.InvocationArgumentConvention argumentConvention = callingConvention.getArgumentConvention(i);
            Class<Object> javaType = argumentType.getJavaType();
            if (argumentType.equals((Object)CHAR_TYPE) || argumentType.equals((Object)TIMESTAMP_TYPE)) {
                javaType = Object.class;
            }
            switch (argumentConvention) {
                case NEVER_NULL: {
                    expectedArguments.add(javaType);
                    continue block9;
                }
                case BOXED_NULLABLE: {
                    expectedArguments.add(Primitives.wrap(javaType));
                    continue block9;
                }
                case NULL_FLAG: {
                    expectedArguments.add(javaType);
                    expectedArguments.add(Boolean.TYPE);
                    continue block9;
                }
                case BLOCK_POSITION_NOT_NULL: 
                case BLOCK_POSITION: {
                    expectedArguments.add(Block.class);
                    expectedArguments.add(Integer.TYPE);
                    continue block9;
                }
                case VALUE_BLOCK_POSITION_NOT_NULL: 
                case VALUE_BLOCK_POSITION: {
                    expectedArguments.add(argumentType.getValueBlockType());
                    expectedArguments.add(Integer.TYPE);
                    continue block9;
                }
                case FLAT: {
                    expectedArguments.add(Slice.class);
                    expectedArguments.add(Integer.TYPE);
                    expectedArguments.add(Slice.class);
                    expectedArguments.add(Integer.TYPE);
                    continue block9;
                }
                case IN_OUT: {
                    expectedArguments.add(InOut.class);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported argument convention: " + String.valueOf(argumentConvention));
                }
            }
        }
        return expectedArguments;
    }

    private static List<Object> toCallArgumentValues(InvocationConvention callingConvention, BitSet nullArguments, Target target, List<Type> argumentTypes) throws Throwable {
        ArrayList<Object> callArguments = new ArrayList<Object>();
        callArguments.add(target);
        block9: for (int i = 0; i < callingConvention.getArgumentConventions().size(); ++i) {
            Type argumentType = argumentTypes.get(i);
            boolean nullArgument = nullArguments.get(i);
            Object testValue = nullArgument ? null : TestScalarFunctionAdapter.getTestValue(argumentType);
            InvocationConvention.InvocationArgumentConvention argumentConvention = callingConvention.getArgumentConvention(i);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    Verify.verify((testValue != null ? 1 : 0) != 0, (String)"null can not be passed to a never null argument", (Object[])new Object[0]);
                    callArguments.add(testValue);
                    continue block9;
                }
                case BOXED_NULLABLE: {
                    callArguments.add(testValue);
                    continue block9;
                }
                case NULL_FLAG: {
                    callArguments.add(testValue == null ? Defaults.defaultValue((Class)argumentType.getJavaType()) : testValue);
                    callArguments.add(testValue == null);
                    continue block9;
                }
                case BLOCK_POSITION_NOT_NULL: 
                case VALUE_BLOCK_POSITION_NOT_NULL: {
                    Verify.verify((testValue != null ? 1 : 0) != 0, (String)"null cannot be passed to a block positions not null argument", (Object[])new Object[0]);
                    BlockBuilder blockBuilder = argumentType.createBlockBuilder(null, 3);
                    blockBuilder.appendNull();
                    TypeUtils.writeNativeValue((Type)argumentType, (BlockBuilder)blockBuilder, (Object)testValue);
                    blockBuilder.appendNull();
                    if (argumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL) {
                        callArguments.add(blockBuilder.build());
                    } else {
                        callArguments.add(blockBuilder.buildValueBlock());
                    }
                    callArguments.add(1);
                    continue block9;
                }
                case BLOCK_POSITION: 
                case VALUE_BLOCK_POSITION: {
                    BlockBuilder blockBuilder = argumentType.createBlockBuilder(null, 3);
                    blockBuilder.appendNull();
                    TypeUtils.writeNativeValue((Type)argumentType, (BlockBuilder)blockBuilder, (Object)testValue);
                    blockBuilder.appendNull();
                    if (argumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) {
                        callArguments.add(blockBuilder.build());
                    } else {
                        callArguments.add(blockBuilder.buildValueBlock());
                    }
                    callArguments.add(1);
                    continue block9;
                }
                case FLAT: {
                    Verify.verify((testValue != null ? 1 : 0) != 0, (String)"null cannot be passed to a flat argument", (Object[])new Object[0]);
                    BlockBuilder blockBuilder = argumentType.createBlockBuilder(null, 3);
                    TypeUtils.writeNativeValue((Type)argumentType, (BlockBuilder)blockBuilder, (Object)testValue);
                    Block block = blockBuilder.build();
                    byte[] fixedSlice = new byte[argumentType.getFlatFixedSize()];
                    int variableWidthLength = argumentType.getFlatVariableWidthSize(block, 0);
                    byte[] variableSlice = new byte[variableWidthLength];
                    MethodHandle writeFlat = TYPE_OPERATORS.getReadValueOperator(argumentType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
                    writeFlat.invokeExact(block, 0, fixedSlice, 0, variableSlice, 0);
                    callArguments.add(fixedSlice);
                    callArguments.add(0);
                    callArguments.add(variableSlice);
                    continue block9;
                }
                case IN_OUT: {
                    callArguments.add(new TestingInOut(argumentType, testValue));
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported argument convention: " + String.valueOf(argumentConvention));
                }
            }
        }
        return callArguments;
    }

    private static Object getTestValue(Type argumentType) {
        if (argumentType.equals((Object)BooleanType.BOOLEAN)) {
            return true;
        }
        if (argumentType.equals((Object)DoubleType.DOUBLE)) {
            return 33.33;
        }
        if (argumentType.equals((Object)BigintType.BIGINT)) {
            return 42L;
        }
        if (argumentType.equals((Object)VarcharType.VARCHAR)) {
            return Slices.utf8Slice((String)"test");
        }
        if (argumentType.equals((Object)ARRAY_TYPE)) {
            BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 4);
            blockBuilder.appendNull();
            BigintType.BIGINT.writeLong(blockBuilder, 99L);
            blockBuilder.appendNull();
            BigintType.BIGINT.writeLong(blockBuilder, 100L);
            return blockBuilder.build();
        }
        if (argumentType.equals((Object)CHAR_TYPE)) {
            return Slices.utf8Slice((String)"1234567");
        }
        if (argumentType.equals((Object)TIMESTAMP_TYPE)) {
            return new LongTimestamp(5678L, 123000);
        }
        throw new IllegalArgumentException("Unsupported argument type: " + String.valueOf(argumentType));
    }

    private static <T> List<List<T>> allCombinations(List<T> values, int n) {
        ImmutableList.Builder combinations = ImmutableList.builder();
        int[] indexes = new int[n];
        block0: do {
            combinations.add((Object)((List)IntStream.of(indexes).mapToObj(values::get).collect(ImmutableList.toImmutableList())));
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                int n2 = i2;
                indexes[n2] = indexes[n2] + 1;
                if (indexes[i2] < values.size()) continue block0;
                indexes[i2] = 0;
            }
        } while (!IntStream.of(indexes).allMatch(i -> i == 0));
        return combinations.build();
    }

    private static class Target {
        private boolean invoked;
        private boolean objectsMethod;
        private Double doubleValue;
        private Slice sliceValue;
        private Block blockValue;
        private Object objectCharValue;
        private Object objectTimestampValue;

        private Target() {
        }

        public boolean neverNull(double doubleValue, Slice sliceValue, Block blockValue) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = false;
            this.doubleValue = doubleValue;
            this.sliceValue = sliceValue;
            this.blockValue = blockValue;
            return true;
        }

        public boolean neverNullObjects(Slice sliceValue, Block blockValue, Object objectCharValue, Object objectTimestampValue) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = true;
            this.sliceValue = sliceValue;
            this.blockValue = blockValue;
            this.objectCharValue = objectCharValue;
            this.objectTimestampValue = objectTimestampValue;
            return true;
        }

        public boolean boxedNull(Double doubleValue, Slice sliceValue, Block blockValue) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = false;
            this.doubleValue = doubleValue;
            this.sliceValue = sliceValue;
            this.blockValue = blockValue;
            return true;
        }

        public boolean boxedNullObjects(Slice sliceValue, Block blockValue, Object objectCharValue, Object objectTimestampValue) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = true;
            this.sliceValue = sliceValue;
            this.blockValue = blockValue;
            this.objectCharValue = objectCharValue;
            this.objectTimestampValue = objectTimestampValue;
            return true;
        }

        public boolean nullFlag(double doubleValue, boolean doubleNull, Slice sliceValue, boolean sliceNull, Block blockValue, boolean blockNull) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = false;
            if (doubleNull) {
                Assertions.assertThat((double)doubleValue).isEqualTo(0.0);
                this.doubleValue = null;
            } else {
                this.doubleValue = doubleValue;
            }
            if (sliceNull) {
                Assertions.assertThat((Comparable)sliceValue).isNull();
                this.sliceValue = null;
            } else {
                this.sliceValue = sliceValue;
            }
            if (blockNull) {
                Assertions.assertThat((Object)blockValue).isNull();
                this.blockValue = null;
            } else {
                this.blockValue = blockValue;
            }
            return true;
        }

        public boolean nullFlagObjects(Slice sliceValue, boolean sliceNull, Block blockValue, boolean blockNull, Object objectCharValue, boolean objectCharNull, Object objectTimestampValue, boolean objectTimestampNull) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = true;
            if (sliceNull) {
                Assertions.assertThat((Comparable)sliceValue).isNull();
                this.sliceValue = null;
            } else {
                this.sliceValue = sliceValue;
            }
            if (blockNull) {
                Assertions.assertThat((Object)blockValue).isNull();
                this.blockValue = null;
            } else {
                this.blockValue = blockValue;
            }
            if (objectCharNull) {
                Assertions.assertThat((Object)objectCharValue).isNull();
                this.objectCharValue = null;
            } else {
                this.objectCharValue = objectCharValue;
            }
            if (objectTimestampNull) {
                Assertions.assertThat((Object)objectTimestampValue).isNull();
                this.objectTimestampValue = null;
            } else {
                this.objectTimestampValue = objectTimestampValue;
            }
            return true;
        }

        public boolean blockPosition(Block doubleBlock, int doublePosition, Block sliceBlock, int slicePosition, Block blockBlock, int blockPosition) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = false;
            this.doubleValue = doubleBlock.isNull(doublePosition) ? null : Double.valueOf(DoubleType.DOUBLE.getDouble(doubleBlock, doublePosition));
            this.sliceValue = sliceBlock.isNull(slicePosition) ? null : VarcharType.VARCHAR.getSlice(sliceBlock, slicePosition);
            this.blockValue = blockBlock.isNull(blockPosition) ? null : ARRAY_TYPE.getObject(blockBlock, blockPosition);
            return true;
        }

        public boolean blockPositionObjects(Block sliceBlock, int slicePosition, Block blockBlock, int blockPosition, Block objectCharBlock, int objectCharPosition, Block objectTimestampBlock, int objectTimestampPosition) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = true;
            this.sliceValue = sliceBlock.isNull(slicePosition) ? null : VarcharType.VARCHAR.getSlice(sliceBlock, slicePosition);
            this.blockValue = blockBlock.isNull(blockPosition) ? null : ARRAY_TYPE.getObject(blockBlock, blockPosition);
            this.objectCharValue = objectCharBlock.isNull(objectCharPosition) ? null : CHAR_TYPE.getObject(objectCharBlock, objectCharPosition);
            this.objectTimestampValue = objectTimestampBlock.isNull(objectTimestampPosition) ? null : TIMESTAMP_TYPE.getObject(objectTimestampBlock, objectTimestampPosition);
            return true;
        }

        public boolean valueBlockPosition(LongArrayBlock doubleBlock, int doublePosition, VariableWidthBlock sliceBlock, int slicePosition, ArrayBlock blockBlock, int blockPosition) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = false;
            this.doubleValue = doubleBlock.isNull(doublePosition) ? null : Double.valueOf(DoubleType.DOUBLE.getDouble((Block)doubleBlock, doublePosition));
            this.sliceValue = sliceBlock.isNull(slicePosition) ? null : VarcharType.VARCHAR.getSlice((Block)sliceBlock, slicePosition);
            this.blockValue = blockBlock.isNull(blockPosition) ? null : ARRAY_TYPE.getObject((Block)blockBlock, blockPosition);
            return true;
        }

        public boolean valueBlockPositionObjects(VariableWidthBlock sliceBlock, int slicePosition, ArrayBlock blockBlock, int blockPosition, VariableWidthBlock objectCharBlock, int objectCharPosition, Fixed12Block objectTimestampBlock, int objectTimestampPosition) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.objectsMethod = true;
            this.sliceValue = sliceBlock.isNull(slicePosition) ? null : VarcharType.VARCHAR.getSlice((Block)sliceBlock, slicePosition);
            this.blockValue = blockBlock.isNull(blockPosition) ? null : ARRAY_TYPE.getObject((Block)blockBlock, blockPosition);
            this.objectCharValue = objectCharBlock.isNull(objectCharPosition) ? null : CHAR_TYPE.getObject((Block)objectCharBlock, objectCharPosition);
            this.objectTimestampValue = objectTimestampBlock.isNull(objectTimestampPosition) ? null : TIMESTAMP_TYPE.getObject((Block)objectTimestampBlock, objectTimestampPosition);
            return true;
        }

        public void verify(InvocationConvention actualConvention, BitSet nullArguments, List<Type> argumentTypes) {
            if (Target.shouldFunctionBeInvoked(actualConvention, nullArguments)) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.invoked).describedAs("function not invoked", new Object[0])).isTrue();
                if (!this.objectsMethod) {
                    Target.assertArgumentValue(this.doubleValue, 0, actualConvention, nullArguments, argumentTypes);
                    Target.assertArgumentValue(this.sliceValue, 1, actualConvention, nullArguments, argumentTypes);
                    Target.assertArgumentValue(this.blockValue, 2, actualConvention, nullArguments, argumentTypes);
                } else {
                    Target.assertArgumentValue(this.sliceValue, 0, actualConvention, nullArguments, argumentTypes);
                    Target.assertArgumentValue(this.blockValue, 1, actualConvention, nullArguments, argumentTypes);
                    Target.assertArgumentValue(this.objectCharValue, 2, actualConvention, nullArguments, argumentTypes);
                    Target.assertArgumentValue(this.objectTimestampValue, 3, actualConvention, nullArguments, argumentTypes);
                }
            } else {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.invoked).describedAs("Function should not be invoked when null is passed to a NEVER_NULL argument", new Object[0])).isFalse();
                Assertions.assertThat((Double)this.doubleValue).isNull();
                Assertions.assertThat((Comparable)this.sliceValue).isNull();
                Assertions.assertThat((Object)this.blockValue).isNull();
                Assertions.assertThat((Object)this.objectCharValue).isNull();
                Assertions.assertThat((Object)this.objectTimestampValue).isNull();
            }
            this.invoked = false;
            this.objectsMethod = false;
            this.doubleValue = null;
            this.sliceValue = null;
            this.blockValue = null;
            this.objectCharValue = null;
            this.objectTimestampValue = null;
        }

        private static boolean shouldFunctionBeInvoked(InvocationConvention actualConvention, BitSet nullArguments) {
            for (int i = 0; i < actualConvention.getArgumentConventions().size(); ++i) {
                InvocationConvention.InvocationArgumentConvention argumentConvention = actualConvention.getArgumentConvention(i);
                if (argumentConvention != InvocationConvention.InvocationArgumentConvention.NEVER_NULL && argumentConvention != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL && argumentConvention != InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL && argumentConvention != InvocationConvention.InvocationArgumentConvention.FLAT || !nullArguments.get(i)) continue;
                return false;
            }
            return true;
        }

        private static void assertArgumentValue(Object actualValue, int index, InvocationConvention actualConvention, BitSet nullArguments, List<Type> argumentTypes) {
            Target.assertArgumentValue(actualValue, actualConvention.getArgumentConvention(index), argumentTypes.get(index), nullArguments.get(index));
        }

        private static void assertArgumentValue(Object actualValue, InvocationConvention.InvocationArgumentConvention argumentConvention, Type argumentType, boolean isNull) {
            if (!isNull) {
                Target.assertArgumentValue(actualValue, TestScalarFunctionAdapter.getTestValue(argumentType));
                return;
            }
            if (argumentConvention != InvocationConvention.InvocationArgumentConvention.NEVER_NULL && argumentConvention != InvocationConvention.InvocationArgumentConvention.FLAT) {
                Assertions.assertThat((Object)actualValue).isNull();
                return;
            }
            if (argumentType.getJavaType().isPrimitive()) {
                Target.assertArgumentValue(actualValue, Defaults.defaultValue((Class)argumentType.getJavaType()));
            }
        }

        private static void assertArgumentValue(Object actual, Object expected) {
            if (actual instanceof Block && expected instanceof Block) {
                Target.assertBlockEquals((Type)BigintType.BIGINT, (Block)actual, (Block)expected);
            } else {
                Assertions.assertThat((Object)actual).isEqualTo(expected);
            }
        }

        private static void assertBlockEquals(Type type, Block actual, Block expected) {
            for (int position = 0; position < actual.getPositionCount(); ++position) {
                Assertions.assertThat((Object)type.getObjectValue(TestingSession.SESSION, actual, position)).isEqualTo(type.getObjectValue(TestingSession.SESSION, expected, position));
            }
        }
    }

    private static class TestingInOut
    implements InOut,
    InternalDataAccessor {
        private final Type type;
        private Object value;

        public TestingInOut(Type type, Object value) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.value = value;
            if (value != null) {
                Class javaType = type.getJavaType();
                if (javaType.equals(Boolean.TYPE)) {
                    Preconditions.checkArgument((boolean)(value instanceof Boolean), (String)"Value must be a Boolean for type %s", (Object)type);
                } else if (javaType.equals(Long.TYPE)) {
                    Preconditions.checkArgument((boolean)(value instanceof Long), (String)"Value must be a Long for type %s", (Object)type);
                } else if (javaType.equals(Double.TYPE)) {
                    Preconditions.checkArgument((boolean)(value instanceof Double), (String)"Value must be a Double for type %s", (Object)type);
                }
            }
        }

        public AccumulatorState copy() {
            return new TestingInOut(this.type, this.value);
        }

        public long getEstimatedSize() {
            return 0L;
        }

        public Type getType() {
            return this.type;
        }

        public final boolean isNull() {
            return this.value == null;
        }

        public final void get(BlockBuilder blockBuilder) {
            Class javaType = this.type.getJavaType();
            Object value = this.value;
            if (value == null) {
                blockBuilder.appendNull();
            } else if (javaType.equals(Boolean.TYPE)) {
                this.type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
            } else if (javaType.equals(Long.TYPE)) {
                this.type.writeLong(blockBuilder, ((Long)value).longValue());
            } else if (javaType.equals(Double.TYPE)) {
                this.type.writeDouble(blockBuilder, ((Double)value).doubleValue());
            } else if (javaType.equals(Slice.class)) {
                this.type.writeSlice(blockBuilder, (Slice)value);
            } else {
                this.type.writeObject(blockBuilder, value);
            }
        }

        public final void set(Block block, int position) {
            Class javaType = this.type.getJavaType();
            Object value = block.isNull(position) ? null : (javaType.equals(Boolean.TYPE) ? Boolean.valueOf(this.type.getBoolean(block, position)) : (javaType.equals(Long.TYPE) ? Long.valueOf(this.type.getLong(block, position)) : (javaType.equals(Double.TYPE) ? Double.valueOf(this.type.getDouble(block, position)) : (javaType.equals(Slice.class) ? this.type.getSlice(block, position) : this.type.getObject(block, position)))));
            this.value = value;
        }

        public final void set(InOut otherState) {
            Preconditions.checkArgument((boolean)this.type.equals((Object)otherState.getType()), (String)"Expected other state to be type %s, but is type %s", (Object)this.type, (Object)otherState.getType());
            Class javaType = this.type.getJavaType();
            Object value = otherState.isNull() ? null : (javaType.equals(Boolean.TYPE) ? Boolean.valueOf(((InternalDataAccessor)otherState).getBooleanValue()) : (javaType.equals(Long.TYPE) ? Long.valueOf(((InternalDataAccessor)otherState).getLongValue()) : (javaType.equals(Double.TYPE) ? Double.valueOf(((InternalDataAccessor)otherState).getDoubleValue()) : ((InternalDataAccessor)otherState).getObjectValue())));
            this.value = value;
        }

        public final boolean getBooleanValue() {
            Preconditions.checkArgument((boolean)this.type.getJavaType().equals(Boolean.TYPE), (String)"Type %s does not have a boolean stack type", (Object)this.type);
            Object value = this.value;
            return value != null && (Boolean)value != false;
        }

        public final double getDoubleValue() {
            Preconditions.checkArgument((boolean)this.type.getJavaType().equals(Double.TYPE), (String)"Type %s does not have a double stack type", (Object)this.type);
            Object value = this.value;
            return value == null ? 0.0 : (Double)value;
        }

        public final long getLongValue() {
            Preconditions.checkArgument((boolean)this.type.getJavaType().equals(Long.TYPE), (String)"Type %s does not have a long stack type", (Object)this.type);
            Object value = this.value;
            return value == null ? 0L : (Long)value;
        }

        public final Object getObjectValue() {
            Preconditions.checkArgument((!this.type.getJavaType().isPrimitive() ? 1 : 0) != 0, (String)"Type %s does not have an Object stack type", (Object)this.type);
            Object value = this.value;
            return value;
        }
    }
}

