/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.TestingBlockJsonSerde;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TestingIdType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDomain {
    @Test
    public void testOrderableNone() {
        Domain domain = Domain.none((Type)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.isNone()).isTrue();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.all((Type)BigintType.BIGINT));
        Assertions.assertThat((String)domain.toString()).isEqualTo("NONE");
    }

    @Test
    public void testEquatableNone() {
        Domain domain = Domain.none((Type)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.isNone()).isTrue();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.all((Type)TestingIdType.ID));
        Assertions.assertThat((String)domain.toString()).isEqualTo("NONE");
    }

    @Test
    public void testUncomparableNone() {
        Domain domain = Domain.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.isNone()).isTrue();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.all((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((String)domain.toString()).isEqualTo("NONE");
    }

    @Test
    public void testOrderableAll() {
        Domain domain = Domain.all((Type)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isTrue();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((String)domain.toString()).isEqualTo("ALL");
    }

    @Test
    public void testFloatingPointOrderableAll() {
        Domain domain = Domain.all((Type)RealType.REAL);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isTrue();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)RealType.REAL));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)RealType.REAL);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(-3.4028235E38f))).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(0.0f))).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(Float.MAX_VALUE))).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(Float.MIN_VALUE))).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(Float.NaN))).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)2143294004L)).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.none((Type)RealType.REAL));
        Assertions.assertThat((String)domain.toString()).isEqualTo("ALL");
        domain = Domain.all((Type)DoubleType.DOUBLE);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isTrue();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)DoubleType.DOUBLE));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)DoubleType.DOUBLE);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)-1.7976931348623157E308)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0.0)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Double.MAX_VALUE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Double.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Double.NaN)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Double.longBitsToDouble(9221140251894092340L))).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.none((Type)DoubleType.DOUBLE));
        Assertions.assertThat((String)domain.toString()).isEqualTo("ALL");
    }

    @Test
    public void testEquatableAll() {
        Domain domain = Domain.all((Type)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isTrue();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.none((Type)TestingIdType.ID));
        Assertions.assertThat((String)domain.toString()).isEqualTo("ALL");
    }

    @Test
    public void testUncomparableAll() {
        Domain domain = Domain.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isTrue();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.none((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((String)domain.toString()).isEqualTo("ALL");
    }

    @Test
    public void testOrderableNullOnly() {
        Domain domain = Domain.onlyNull((Type)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isTrue();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.notNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)domain.getNullableSingleValue()).isEqualTo(null);
        Assertions.assertThat((String)domain.toString()).isEqualTo("[NULL]");
    }

    @Test
    public void testEquatableNullOnly() {
        Domain domain = Domain.onlyNull((Type)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isTrue();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isTrue();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.notNull((Type)TestingIdType.ID));
        Assertions.assertThat((Object)domain.getNullableSingleValue()).isEqualTo(null);
        Assertions.assertThat((String)domain.toString()).isEqualTo("[NULL]");
    }

    @Test
    public void testUncomparableNullOnly() {
        Domain domain = Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isTrue();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isTrue();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isTrue();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isTrue();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)domain.getNullableSingleValue()).isEqualTo(null);
        Assertions.assertThat((String)domain.toString()).isEqualTo("[NULL]");
    }

    @Test
    public void testOrderableNotNull() {
        Domain domain = Domain.notNull((Type)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((String)domain.toString()).isEqualTo("[ SortedRangeSet[type=bigint, ranges=1, {(<min>,<max>)}] ]");
    }

    @Test
    public void testEquatableNotNull() {
        Domain domain = Domain.notNull((Type)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.onlyNull((Type)TestingIdType.ID));
        Assertions.assertThat((String)domain.toString()).isEqualTo("[ EquatableValueSet[type=id, values=0, EXCLUDES{}] ]");
    }

    @Test
    public void testUncomparableNotNull() {
        Domain domain = Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isFalse();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((String)domain.toString()).isEqualTo("[ [ALL] ]");
    }

    @Test
    public void testOrderableSingleValue() {
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)0L);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isTrue();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isTrue();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE)).isFalse();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)true));
        Assertions.assertThat((Object)domain.getSingleValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)domain.getNullableSingleValue()).isEqualTo((Object)0L);
        Assertions.assertThat((String)domain.toString()).isEqualTo("[ SortedRangeSet[type=bigint, ranges=1, {[0]}] ]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("Domain is not a single value");
    }

    @Test
    public void testEquatableSingleValue() {
        Domain domain = Domain.singleValue((Type)TestingIdType.ID, (Object)0L);
        Assertions.assertThat((boolean)domain.isNone()).isFalse();
        Assertions.assertThat((boolean)domain.isAll()).isFalse();
        Assertions.assertThat((boolean)domain.isSingleValue()).isTrue();
        Assertions.assertThat((boolean)domain.isNullableSingleValue()).isTrue();
        Assertions.assertThat((boolean)domain.isOnlyNull()).isFalse();
        Assertions.assertThat((boolean)domain.isNullAllowed()).isFalse();
        Assertions.assertThat((Object)domain.getValues()).isEqualTo((Object)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)domain.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)domain.includesNullableValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)domain.includesNullableValue(null)).isFalse();
        Assertions.assertThat((Object)domain.complement()).isEqualTo((Object)Domain.create((ValueSet)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement(), (boolean)true));
        Assertions.assertThat((Object)domain.getSingleValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)domain.getNullableSingleValue()).isEqualTo((Object)0L);
        Assertions.assertThat((String)domain.toString()).isEqualTo("[ EquatableValueSet[type=id, values=1, {0}] ]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Domain.create((ValueSet)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}), (boolean)false).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("Domain is not a single value");
    }

    @Test
    public void testUncomparableSingleValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Domain.singleValue((Type)HyperLogLogType.HYPER_LOG_LOG, (Object)Slices.EMPTY_SLICE)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create discrete ValueSet with non-comparable type: HyperLogLog");
    }

    @Test
    public void testOverlaps() {
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isFalse();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isFalse();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.all((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.none((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.notNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.onlyNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isTrue();
    }

    @Test
    public void testContains() {
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isFalse();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isFalse();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.notNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.onlyNull((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isTrue();
    }

    @Test
    public void testIntersect() {
        Assertions.assertThat((Object)Domain.all((Type)BigintType.BIGINT).intersect(Domain.all((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.none((Type)BigintType.BIGINT).intersect(Domain.none((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.all((Type)BigintType.BIGINT).intersect(Domain.none((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.notNull((Type)BigintType.BIGINT).intersect(Domain.onlyNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).intersect(Domain.all((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assertions.assertThat((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).intersect(Domain.onlyNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true))).isEqualTo((Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))).isEqualTo((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
    }

    @Test
    public void testUnion() {
        this.assertUnion(Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.none((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT));
        this.assertUnion(Domain.all((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.notNull((Type)BigintType.BIGINT), Domain.onlyNull((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.notNull((Type)BigintType.BIGINT), Domain.notNull((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.onlyNull((Type)BigintType.BIGINT), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)true));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)20L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), (boolean)true), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)20L), (Range[])new Range[0]), (boolean)false), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), (boolean)false), Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT), (boolean)false));
    }

    @Test
    public void testSubtract() {
        Assertions.assertThat((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.notNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)true));
        Assertions.assertThat((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.notNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.notNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)false));
        Assertions.assertThat((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isEqualTo((Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.all((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.none((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assertions.assertThat((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.notNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.onlyNull((Type)BigintType.BIGINT))).isEqualTo((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assertions.assertThat((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L))).isEqualTo((Object)Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true))).isEqualTo((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
        Assertions.assertThat((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))).isEqualTo((Object)Domain.onlyNull((Type)BigintType.BIGINT));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        Domain domain = Domain.all((Type)BigintType.BIGINT);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.none((Type)DoubleType.DOUBLE);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.notNull((Type)BooleanType.BOOLEAN);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.onlyNull((Type)VarcharType.VARCHAR);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)Long.MIN_VALUE);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.singleValue((Type)TestingIdType.ID, (Object)Long.MIN_VALUE);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)3L, (boolean)true)}), (boolean)true);
        Assertions.assertThat((Object)domain).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
    }

    private void assertUnion(Domain first, Domain second, Domain expected) {
        Assertions.assertThat((Object)first.union(second)).isEqualTo((Object)expected);
        Assertions.assertThat((Object)Domain.union((List)ImmutableList.of((Object)first, (Object)second))).isEqualTo((Object)expected);
    }
}

