/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.TestingBlockJsonSerde;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.EquatableValueSet;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.TestingIdType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEquatableValueSet {
    @Test
    public void testEmptySet() {
        EquatableValueSet equatables = EquatableValueSet.none((Type)TestingIdType.ID);
        Assertions.assertThat((Object)equatables.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)equatables.isNone()).isTrue();
        Assertions.assertThat((boolean)equatables.isAll()).isFalse();
        Assertions.assertThat((boolean)equatables.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)equatables.inclusive()).isTrue();
        Assertions.assertThat((int)equatables.getValues().size()).isEqualTo(0);
        Assertions.assertThat((Object)equatables.complement()).isEqualTo((Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((boolean)equatables.containsValue((Object)0L)).isFalse();
        Assertions.assertThat((boolean)equatables.containsValue((Object)1L)).isFalse();
        Assertions.assertThat((String)equatables.toString()).isEqualTo("EquatableValueSet[type=id, values=0, {}]");
    }

    @Test
    public void testEntireSet() {
        EquatableValueSet equatables = EquatableValueSet.all((Type)TestingIdType.ID);
        Assertions.assertThat((Object)equatables.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)equatables.isNone()).isFalse();
        Assertions.assertThat((boolean)equatables.isAll()).isTrue();
        Assertions.assertThat((boolean)equatables.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)equatables.inclusive()).isFalse();
        Assertions.assertThat((int)equatables.getValues().size()).isEqualTo(0);
        Assertions.assertThat((Object)equatables.complement()).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((boolean)equatables.containsValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)equatables.containsValue((Object)1L)).isTrue();
    }

    @Test
    public void testSingleValue() {
        EquatableValueSet equatables = EquatableValueSet.of((Type)TestingIdType.ID, (Object)10L, (Object[])new Object[0]);
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)equatables);
        Assertions.assertThat((Object)equatables.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)equatables.isNone()).isFalse();
        Assertions.assertThat((boolean)equatables.isAll()).isFalse();
        Assertions.assertThat((boolean)equatables.isSingleValue()).isTrue();
        Assertions.assertThat((boolean)equatables.inclusive()).isTrue();
        Assertions.assertThat((boolean)Iterables.elementsEqual((Iterable)equatables.getValues(), (Iterable)ImmutableList.of((Object)10L))).isTrue();
        Assertions.assertThat((Object)equatables.complement()).isEqualTo((Object)complement);
        Assertions.assertThat((boolean)equatables.containsValue((Object)0L)).isFalse();
        Assertions.assertThat((boolean)equatables.containsValue((Object)1L)).isFalse();
        Assertions.assertThat((boolean)equatables.containsValue((Object)10L)).isTrue();
        Assertions.assertThat((Object)complement.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)complement.isNone()).isFalse();
        Assertions.assertThat((boolean)complement.isAll()).isFalse();
        Assertions.assertThat((boolean)complement.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)complement.inclusive()).isFalse();
        Assertions.assertThat((boolean)Iterables.elementsEqual((Iterable)complement.getValues(), (Iterable)ImmutableList.of((Object)10L))).isTrue();
        Assertions.assertThat((Object)complement.complement()).isEqualTo((Object)equatables);
        Assertions.assertThat((boolean)complement.containsValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)complement.containsValue((Object)1L)).isTrue();
        Assertions.assertThat((boolean)complement.containsValue((Object)10L)).isFalse();
    }

    @Test
    public void testMultipleValues() {
        EquatableValueSet equatables = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L, 3L, 1L});
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)equatables);
        Assertions.assertThat((Object)equatables.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)equatables.isNone()).isFalse();
        Assertions.assertThat((boolean)equatables.isAll()).isFalse();
        Assertions.assertThat((boolean)equatables.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)equatables.inclusive()).isTrue();
        Assertions.assertThat((boolean)Iterables.elementsEqual((Iterable)equatables.getValues(), (Iterable)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))).isTrue();
        Assertions.assertThat((Object)equatables.complement()).isEqualTo((Object)complement);
        Assertions.assertThat((boolean)equatables.containsValue((Object)0L)).isFalse();
        Assertions.assertThat((boolean)equatables.containsValue((Object)1L)).isTrue();
        Assertions.assertThat((boolean)equatables.containsValue((Object)2L)).isTrue();
        Assertions.assertThat((boolean)equatables.containsValue((Object)3L)).isTrue();
        Assertions.assertThat((boolean)equatables.containsValue((Object)4L)).isFalse();
        Assertions.assertThat((String)equatables.toString()).isEqualTo("EquatableValueSet[type=id, values=3, {1, 2, 3}]");
        Assertions.assertThat((String)equatables.toString((ConnectorSession)ToStringSession.INSTANCE, 2)).isEqualTo("EquatableValueSet[type=id, values=3, {1, 2, ...}]");
        Assertions.assertThat((Object)complement.getType()).isEqualTo((Object)TestingIdType.ID);
        Assertions.assertThat((boolean)complement.isNone()).isFalse();
        Assertions.assertThat((boolean)complement.isAll()).isFalse();
        Assertions.assertThat((boolean)complement.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)complement.inclusive()).isFalse();
        Assertions.assertThat((boolean)Iterables.elementsEqual((Iterable)complement.getValues(), (Iterable)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))).isTrue();
        Assertions.assertThat((Object)complement.complement()).isEqualTo((Object)equatables);
        Assertions.assertThat((boolean)complement.containsValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)complement.containsValue((Object)1L)).isFalse();
        Assertions.assertThat((boolean)complement.containsValue((Object)2L)).isFalse();
        Assertions.assertThat((boolean)complement.containsValue((Object)3L)).isFalse();
        Assertions.assertThat((boolean)complement.containsValue((Object)4L)).isTrue();
        Assertions.assertThat((String)complement.toString()).isEqualTo("EquatableValueSet[type=id, values=3, EXCLUDES{1, 2, 3}]");
        Assertions.assertThat((String)complement.toString((ConnectorSession)ToStringSession.INSTANCE, 2)).isEqualTo("EquatableValueSet[type=id, values=3, EXCLUDES{1, 2, ...}]");
    }

    @Test
    public void testGetSingleValue() {
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).getSingleValue()).isEqualTo((Object)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EquatableValueSet.all((Type)TestingIdType.ID).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("EquatableValueSet does not have just a single value");
    }

    @Test
    public void testOverlaps() {
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement())).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement())).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement())).isTrue();
    }

    @Test
    public void testContains() {
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement())).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isFalse();
        Assertions.assertThat((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement())).isFalse();
    }

    @Test
    public void testIntersect() {
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)2L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L, 2L}).complement());
    }

    @Test
    public void testUnion() {
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement());
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L, 2L}));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement());
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
    }

    @Test
    public void testSubtract() {
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assertions.assertThat((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement())).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement())).isEqualTo((Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}))).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assertions.assertThat((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement())).isEqualTo((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
    }

    @Test
    public void testUnmodifiableCollection() {
        Collection values = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getValues();
        Assertions.assertThatThrownBy(values::clear).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testUnmodifiableValueEntries() {
        Set entries = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getEntries();
        Assertions.assertThatThrownBy(entries::clear).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testUnmodifiableIterator() {
        Iterator iterator = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getValues().iterator();
        iterator.next();
        Assertions.assertThatThrownBy(iterator::remove).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testUnmodifiableValueEntryIterator() {
        Iterator iterator = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getEntries().iterator();
        iterator.next();
        Assertions.assertThatThrownBy(iterator::remove).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        EquatableValueSet set = EquatableValueSet.all((Type)TestingIdType.ID);
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.none((Type)TestingIdType.ID);
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]);
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L});
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).complement();
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
    }

    @Test
    public void testExpandRanges() {
        Assertions.assertThat((Optional)ValueSet.all((Type)TestingIdType.ID).tryExpandRanges(10)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.none((Type)TestingIdType.ID).tryExpandRanges(10)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.none((Type)TestingIdType.ID).tryExpandRanges(1)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.none((Type)TestingIdType.ID).tryExpandRanges(0)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(3)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L))));
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(2)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L))));
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(1)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(0)).isEqualTo(Optional.empty());
    }
}

