/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.TestingBlockJsonSerde;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSortedRangeSet {
    @Test
    public void testEmptySet() {
        SortedRangeSet rangeSet = SortedRangeSet.none((Type)BigintType.BIGINT);
        Assertions.assertThat((Object)rangeSet.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)rangeSet.isNone()).isTrue();
        Assertions.assertThat((boolean)rangeSet.isAll()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isDiscreteSet()).isFalse();
        Assertions.assertThat((boolean)rangeSet.getOrderedRanges().isEmpty()).isTrue();
        Assertions.assertThat((int)rangeSet.getRangeCount()).isEqualTo(0);
        Assertions.assertThat((Object)rangeSet.complement()).isEqualTo((Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)0L)).isFalse();
        Assertions.assertThat((String)rangeSet.toString()).isEqualTo("SortedRangeSet[type=bigint, ranges=0, {}]");
    }

    @Test
    public void testEntireSet() {
        SortedRangeSet rangeSet = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assertions.assertThat((Object)rangeSet.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)rangeSet.isNone()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isAll()).isTrue();
        Assertions.assertThat((boolean)rangeSet.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isDiscreteSet()).isFalse();
        Assertions.assertThat((int)rangeSet.getRangeCount()).isEqualTo(1);
        Assertions.assertThat((Object)rangeSet.complement()).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)0L)).isTrue();
        Assertions.assertThat((String)rangeSet.toString()).isEqualTo("SortedRangeSet[type=bigint, ranges=1, {(<min>,<max>)}]");
    }

    @Test
    public void testSingleValue() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)10L, (Object[])new Object[0]);
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((Object)rangeSet.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)rangeSet.isNone()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isAll()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isSingleValue()).isTrue();
        Assertions.assertThat((boolean)rangeSet.isDiscreteSet()).isTrue();
        Assertions.assertThat((List)rangeSet.getOrderedRanges()).isEqualTo((Object)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)10L)));
        Assertions.assertThat((int)rangeSet.getRangeCount()).isEqualTo(1);
        Assertions.assertThat((Object)rangeSet.complement()).isEqualTo((Object)complement);
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)10L)).isTrue();
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)9L)).isFalse();
        Assertions.assertThat((String)rangeSet.toString()).isEqualTo("SortedRangeSet[type=bigint, ranges=1, {[10]}]");
        Assertions.assertThat((String)SortedRangeSet.of((Range)Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"LARGE PLATED NICKEL")), (Range[])new Range[0]).toString()).isEqualTo("SortedRangeSet[type=varchar, ranges=1, {[LARGE PLATED NICKEL]}]");
    }

    @Test
    public void testBoundedSet() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false), Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)false, (Object)5L, (boolean)true)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)5L, (boolean)true), (Object)Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)false, (Object)9L, (boolean)false), Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)11L)});
        Assertions.assertThat((Object)rangeSet.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)rangeSet.isNone()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isAll()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isDiscreteSet()).isFalse();
        Assertions.assertThat((List)rangeSet.getOrderedRanges()).isEqualTo((Object)normalizedResult);
        Assertions.assertThat((Object)rangeSet).isEqualTo((Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assertions.assertThat((int)rangeSet.getRangeCount()).isEqualTo(3);
        Assertions.assertThat((Object)rangeSet.complement()).isEqualTo((Object)complement);
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)1L)).isFalse();
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)7L)).isFalse();
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)9L)).isTrue();
        Assertions.assertThat((String)rangeSet.toString()).isEqualTo("SortedRangeSet[type=bigint, ranges=3, {[0], [2,5], [9,11)}]");
        Assertions.assertThat((String)rangeSet.toString((ConnectorSession)ToStringSession.INSTANCE, 2)).isEqualTo("SortedRangeSet[type=bigint, ranges=3, {[0], ..., [9,11)}]");
        Assertions.assertThat((String)rangeSet.toString((ConnectorSession)ToStringSession.INSTANCE, 1)).isEqualTo("SortedRangeSet[type=bigint, ranges=3, {[0], ...}]");
    }

    @Test
    public void testUnboundedSet() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)true, (Object)6L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)false, (Object)11L, (boolean)false)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)6L, (boolean)false), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)9L));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)6L, (boolean)true, (Object)9L, (boolean)true)});
        Assertions.assertThat((Object)rangeSet.getType()).isEqualTo((Object)BigintType.BIGINT);
        Assertions.assertThat((boolean)rangeSet.isNone()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isAll()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)rangeSet.isDiscreteSet()).isFalse();
        Assertions.assertThat((List)rangeSet.getOrderedRanges()).isEqualTo((Object)normalizedResult);
        Assertions.assertThat((Object)rangeSet).isEqualTo((Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assertions.assertThat((int)rangeSet.getRangeCount()).isEqualTo(3);
        Assertions.assertThat((Object)rangeSet.complement()).isEqualTo((Object)complement);
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)0L)).isTrue();
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)4L)).isTrue();
        Assertions.assertThat((boolean)rangeSet.containsValue((Object)7L)).isFalse();
        Assertions.assertThat((String)rangeSet.toString()).isEqualTo("SortedRangeSet[type=bigint, ranges=3, {(<min>,0], (1,6), (9,<max>)}]");
    }

    @Test
    public void testCreateWithRanges() {
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)5L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)5L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)5L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)5L)});
        Assertions.assertThat((List)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)10L)}).getOrderedRanges()).containsExactly((Object[])new Range[]{Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)});
    }

    @Test
    public void testGetSingleValue() {
        Assertions.assertThat((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSingleValue()).isEqualTo((Object)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SortedRangeSet.all((Type)BigintType.BIGINT).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("SortedRangeSet does not have just a single value");
    }

    @Test
    public void testSpan() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SortedRangeSet.none((Type)BigintType.BIGINT).getSpan()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot get span if no ranges exist");
        Assertions.assertThat((Object)SortedRangeSet.all((Type)BigintType.BIGINT).getSpan()).isEqualTo((Object)Range.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSpan()).isEqualTo((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).getSpan()).isEqualTo((Object)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)1L, (boolean)true));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan()).isEqualTo((Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan()).isEqualTo((Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() {
        this.assertOverlaps(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertDoesNotOverlap(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertOverlaps(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        this.assertOverlaps(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}));
        this.assertOverlaps(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertOverlaps(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)}));
        this.assertDoesNotOverlap(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertDoesNotOverlap(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertDoesNotOverlap(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}));
        this.assertDoesNotOverlap(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertDoesNotOverlap(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)}));
        this.assertOverlaps(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertDoesNotOverlap(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertOverlaps(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        this.assertOverlaps(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}));
        this.assertDoesNotOverlap(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertDoesNotOverlap(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)}));
        this.assertOverlaps(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]));
        this.assertDoesNotOverlap(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]));
        this.assertOverlaps(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertOverlaps(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertDoesNotOverlap(SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        SortedRangeSet testRangeSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)500L, (Object[])LongStream.range(501L, 1001L).boxed().filter(i -> i % 4L == 0L).toList().toArray());
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)500L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)499L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)400L, (Object[])LongStream.range(401L, 500L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)515L, (Object[])LongStream.range(530L, 550L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)false, (Object)399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)400L, (boolean)false, (Object)499L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)false, (Object)399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)400L, (boolean)false, (Object)501L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1000L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1001L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)965L, (Object[])LongStream.range(966L, 1100L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)955L, (Object[])LongStream.range(956L, 1100L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1001L, (Object[])LongStream.range(1002L, 1100L).boxed().toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)1000L, (boolean)false, (Object)1399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)1400L, (boolean)false, (Object)1499L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)999L, (boolean)false, (Object)1399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)1400L, (boolean)false, (Object)1501L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)768L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)769L, (Object[])new Object[0]));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)715L, (Object[])LongStream.range(730L, 800L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)715L, (Object[])LongStream.range(730L, 780L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)768L, (boolean)false, (Object)772L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)772L, (boolean)false, (Object)776L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)764L, (boolean)false, (Object)770L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)772L, (boolean)false, (Object)776L, (boolean)false)}));
        testRangeSet = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)499L, (boolean)false, (Object)505L, (boolean)false), (Range[])((Range[])LongStream.range(100L, 201L).filter(i -> i % 10L == 0L).mapToObj(i -> Range.range((Type)BigintType.BIGINT, (Object)(i * 5L), (boolean)false, (Object)((i + 1L) * 5L), (boolean)false)).toList().toArray(Range[]::new)));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)500L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)499L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)400L, (Object[])LongStream.range(401L, 500L).boxed().toList().toArray()));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)520L, (Object[])new Object[]{540L, 551L}));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)false, (Object)399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)400L, (boolean)false, (Object)499L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)false, (Object)399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)400L, (boolean)false, (Object)501L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1001L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1005L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)965L, (Object[])LongStream.range(966L, 1100L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)950L, (Object[])new Object[]{970L, 999L, 1001L, 1006L}));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1005L, (Object[])LongStream.range(1006L, 1100L).boxed().toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)1005L, (boolean)false, (Object)1399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)1400L, (boolean)false, (Object)1499L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)999L, (boolean)false, (Object)1399L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)1400L, (boolean)false, (Object)1501L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)754L, (Object[])new Object[0]));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)755L, (Object[])new Object[0]));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)715L, (Object[])LongStream.range(730L, 800L).boxed().toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Type)BigintType.BIGINT, (Object)715L, (Object[])LongStream.range(730L, 780L).boxed().filter(i -> i % 15L == 0L).toList().toArray()));
        this.assertDoesNotOverlap(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)768L, (boolean)false, (Object)772L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)772L, (boolean)false, (Object)776L, (boolean)false)}));
        this.assertOverlaps(testRangeSet, SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)750L, (boolean)false, (Object)770L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)772L, (boolean)false, (Object)776L, (boolean)false)}));
    }

    private void assertOverlaps(SortedRangeSet first, SortedRangeSet second) {
        Assertions.assertThat((boolean)first.overlaps((ValueSet)second)).isTrue();
        Assertions.assertThat((boolean)first.linearSearchOverlaps(second)).isTrue();
        Assertions.assertThat((boolean)first.binarySearchOverlaps(second)).isTrue();
        Assertions.assertThat((boolean)second.overlaps((ValueSet)first)).isTrue();
        Assertions.assertThat((boolean)second.linearSearchOverlaps(first)).isTrue();
        Assertions.assertThat((boolean)second.binarySearchOverlaps(first)).isTrue();
    }

    private void assertDoesNotOverlap(SortedRangeSet first, SortedRangeSet second) {
        Assertions.assertThat((boolean)first.overlaps((ValueSet)second)).isFalse();
        Assertions.assertThat((boolean)first.linearSearchOverlaps(second)).isFalse();
        Assertions.assertThat((boolean)first.binarySearchOverlaps(second)).isFalse();
        Assertions.assertThat((boolean)second.overlaps((ValueSet)first)).isFalse();
        Assertions.assertThat((boolean)second.linearSearchOverlaps(first)).isFalse();
        Assertions.assertThat((boolean)second.binarySearchOverlaps(first)).isFalse();
    }

    @Test
    public void testContains() {
        Assertions.assertThat((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)}))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)}))).isFalse();
        SortedRangeSet valueSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]);
        Assertions.assertThat((boolean)valueSet.contains((ValueSet)valueSet)).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)}))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isFalse();
        Range rangeA = Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true);
        Range rangeB = Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)true, (Object)6L, (boolean)true);
        Range rangeC = Range.range((Type)BigintType.BIGINT, (Object)8L, (boolean)true, (Object)10L, (boolean)true);
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB}).contains((ValueSet)SortedRangeSet.of((Range)rangeC, (Range[])new Range[0]))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeB, (Range[])new Range[]{rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeA, (Range[])new Range[0]))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeB, (Range[])new Range[0]))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB}).contains((ValueSet)SortedRangeSet.of((Range)rangeB, (Range[])new Range[]{rangeC}))).isFalse();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeA, (Range[])new Range[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeB, (Range[])new Range[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)rangeC, (Range[])new Range[0]))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)6L), Range.equal((Type)BigintType.BIGINT, (Object)9L)}))).isTrue();
        Assertions.assertThat((boolean)SortedRangeSet.of((Range)rangeA, (Range[])new Range[]{rangeB, rangeC}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)6L, (boolean)true, (Object)10L, (boolean)true)}))).isFalse();
    }

    @Test
    public void testContainsValue() {
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)BigintType.BIGINT)).containsValue(Long.MIN_VALUE).containsValue(0L).containsValue(42L).containsValue(Long.MAX_VALUE);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)41L, (boolean)true), (Range[])new Range[0])).doesNotContainValue(9L).containsValue(10L).containsValue(11L).containsValue(30L).containsValue(41L).doesNotContainValue(42L);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)41L, (boolean)false), (Range[])new Range[0])).doesNotContainValue(10L).containsValue(11L).containsValue(40L).doesNotContainValue(41L);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)RealType.REAL)).containsValue(Float.floatToRawIntBits(42.0f)).containsValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(10.0f), (boolean)true, (Object)Float.floatToRawIntBits(41.0f), (boolean)true), (Range[])new Range[0])).doesNotContainValue(Float.floatToRawIntBits(9.999999f)).containsValue(Float.floatToRawIntBits(10.0f)).containsValue(Float.floatToRawIntBits(41.0f)).doesNotContainValue(Float.floatToRawIntBits(41.00001f)).doesNotContainValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(10.0f), (boolean)false, (Object)Float.floatToRawIntBits(41.0f), (boolean)false), (Range[])new Range[0])).doesNotContainValue(Float.floatToRawIntBits(10.0f)).containsValue(Float.floatToRawIntBits(10.00001f)).containsValue(Float.floatToRawIntBits(40.99999f)).doesNotContainValue(Float.floatToRawIntBits(41.0f)).doesNotContainValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)DoubleType.DOUBLE)).containsValue(42.0).containsValue(Double.NaN);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)DoubleType.DOUBLE, (Object)10.0, (boolean)true, (Object)41.0, (boolean)true), (Range[])new Range[0])).doesNotContainValue(9.999999999999998).containsValue(10.0).containsValue(41.0).doesNotContainValue(41.00000000000001).doesNotContainValue(Double.NaN);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)DoubleType.DOUBLE, (Object)10.0, (boolean)false, (Object)41.0, (boolean)false), (Range[])new Range[0])).doesNotContainValue(10.0).containsValue(10.00000000000001).containsValue(40.99999999999999).doesNotContainValue(41.0).doesNotContainValue(Double.NaN);
    }

    @Test
    public void testContainsValueRejectNull() {
        SortedRangeSet all = SortedRangeSet.all((Type)BigintType.BIGINT);
        SortedRangeSet none = SortedRangeSet.none((Type)BigintType.BIGINT);
        SortedRangeSet someRange = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)41L, (boolean)false), (Range[])new Range[0]);
        Assertions.assertThatThrownBy(() -> all.containsValue(null)).hasMessage("value is null");
        Assertions.assertThatThrownBy(() -> none.containsValue(null)).hasMessage("value is null");
        Assertions.assertThatThrownBy(() -> someRange.containsValue(null)).hasMessage("value is null");
    }

    @Test
    public void testIntersect() {
        this.assertIntersect(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertIntersect(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertIntersect(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertIntersect(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertIntersect(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]));
        this.assertIntersect(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)}));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)3L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)false, (Object)4L, (boolean)false)}));
        this.assertIntersect(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertIntersect(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)-1L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)-1L, (boolean)true, (Object)1L, (boolean)true), (Range[])new Range[0]));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)18L, (boolean)true)}), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)true, (Object)15L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)17L, (boolean)true, (Object)21L, (boolean)true)}), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)15L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)17L, (boolean)true, (Object)18L, (boolean)true)}));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)18L, (boolean)true)}), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])LongStream.rangeClosed(1L, 25L).boxed().toArray()), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])Stream.concat(LongStream.rangeClosed(2L, 9L).boxed(), LongStream.rangeClosed(12L, 18L).boxed()).toArray()));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)9L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)false, (Object)18L, (boolean)false)}), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])LongStream.rangeClosed(1L, 25L).boxed().toArray()), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)3L, (Object[])Stream.concat(LongStream.rangeClosed(4L, 8L).boxed(), LongStream.rangeClosed(13L, 17L).boxed()).toArray()));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)50L, (boolean)true), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)50L, (boolean)false, (Object)100L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)150L, (boolean)true, (Object)200L, (boolean)true)}), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)50L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)50L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)150L, (boolean)true, (Object)200L, (boolean)true)}), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)200L, (boolean)true, (Object)300L, (boolean)true), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)50L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)150L, (boolean)true, (Object)200L, (boolean)false)}), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)20L, (boolean)true), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)8L, (boolean)true, (Object)12L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)18L, (boolean)true, (Object)22L, (boolean)true)}), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)12L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)18L, (boolean)true, (Object)20L, (boolean)true)}));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)20L, (boolean)true), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)18L, (boolean)true), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)18L, (boolean)true), (Range[])new Range[0]));
        this.assertIntersect(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)20L, (boolean)true), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)14L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)16L, (boolean)true, (Object)18L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)22L, (boolean)true, (Object)24L, (boolean)true)}), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)14L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)16L, (boolean)true, (Object)18L, (boolean)true)}));
        this.assertIntersect(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])((Range[])LongStream.range(1L, 5L).mapToObj(l -> Range.range((Type)BigintType.BIGINT, (Object)(l * 10L), (l % 2L == 0L ? 1 : 0) != 0, (Object)((l + 1L) * 10L - 1L), (l % 2L == 1L ? 1 : 0) != 0)).toList().toArray(Range[]::new))), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)30L, (boolean)true), (Range[])((Range[])LongStream.rangeClosed(4L, 10L).mapToObj(l -> Range.range((Type)BigintType.BIGINT, (Object)(l * 10L), (l % 2L == 1L ? 1 : 0) != 0, (Object)((l + 1L) * 10L - 1L), (l % 2L == 0L ? 1 : 0) != 0)).toList().toArray(Range[]::new))), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)19L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)20L, (boolean)true, (Object)29L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)40L, (boolean)false, (Object)49L, (boolean)false)}));
        List<Slice> slices = IntStream.rangeClosed(0, 500).mapToObj(String::valueOf).map(Slices::utf8Slice).sorted().toList();
        this.assertIntersect(SortedRangeSet.copyOf((Type)VarcharType.VARCHAR, Stream.concat(IntStream.range(0, 2).mapToObj(l -> Range.range((Type)VarcharType.VARCHAR, slices.get(l * 50), (l % 2 == 0 ? 1 : 0) != 0, slices.get((l + 1) * 50 - 1), (l % 2 == 1 ? 1 : 0) != 0)), IntStream.range(3, 5).mapToObj(l -> Range.range((Type)VarcharType.VARCHAR, slices.get(l * 50), (l % 2 == 0 ? 1 : 0) != 0, slices.get((l + 1) * 50 - 1), (l % 2 == 1 ? 1 : 0) != 0))).toList()), SortedRangeSet.copyOf((Type)VarcharType.VARCHAR, IntStream.rangeClosed(1, 50).mapToObj(l -> Range.range((Type)VarcharType.VARCHAR, slices.get(l * 5), (l % 2 == 1 ? 1 : 0) != 0, slices.get((l + 1) * 5 - 1), (l % 2 == 0 ? 1 : 0) != 0)).toList()), SortedRangeSet.copyOf((Type)VarcharType.VARCHAR, Stream.concat(IntStream.rangeClosed(1, 19).mapToObj(l -> Range.range((Type)VarcharType.VARCHAR, slices.get(l * 5), (l % 2 == 1 ? 1 : 0) != 0, slices.get((l + 1) * 5 - 1), (l % 2 == 0 ? 1 : 0) != 0)), IntStream.rangeClosed(30, 49).mapToObj(l -> Range.range((Type)VarcharType.VARCHAR, slices.get(l * 5), (l % 2 == 1 ? 1 : 0) != 0, slices.get((l + 1) * 5 - 1), (l % 2 == 0 ? 1 : 0) != 0))).toList()));
    }

    @Test
    public void testLinearDiscreteSetIntersect() {
        SortedRangeSet result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 10L, 11L, 20L, 21L}).linearDiscreteSetIntersect(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 20L, 21L, 30L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 20L, 21L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 10L}).linearDiscreteSetIntersect(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 11L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 10L}).linearDiscreteSetIntersect(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)42L, (Object[])new Object[0]));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isFalse();
    }

    private void assertIntersect(SortedRangeSet first, SortedRangeSet second, SortedRangeSet result) {
        Assertions.assertThat((Object)first.intersect((ValueSet)second)).isEqualTo((Object)result);
        Assertions.assertThat((Object)first.linearSearchIntersect(second)).isEqualTo((Object)result);
        Assertions.assertThat((Object)first.binarySearchIntersect(second)).isEqualTo((Object)result);
        Assertions.assertThat((Object)second.intersect((ValueSet)first)).isEqualTo((Object)result);
        Assertions.assertThat((Object)second.linearSearchIntersect(first)).isEqualTo((Object)result);
        Assertions.assertThat((Object)second.binarySearchIntersect(first)).isEqualTo((Object)result);
        first.isDiscreteSet();
        second.isDiscreteSet();
        Assertions.assertThat((Comparable)first.getDiscreteSetMarker()).isNotEqualTo((Object)SortedRangeSet.DiscreteSetMarker.UNKNOWN);
        Assertions.assertThat((Comparable)second.getDiscreteSetMarker()).isNotEqualTo((Object)SortedRangeSet.DiscreteSetMarker.UNKNOWN);
        Assertions.assertThat((boolean)first.intersect((ValueSet)second).isDiscreteSet()).isEqualTo(result.isDiscreteSet());
    }

    @Test
    public void testUnion() {
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)3L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)3L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.all((Type)BigintType.BIGINT), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)10L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)9L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)10L, (boolean)false), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)5L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED "), (boolean)true, (Object)Slices.utf8Slice((String)"LARGE PLATED!"), (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.equal((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED NICKEL")), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED "), (boolean)true, (Object)Slices.utf8Slice((String)"LARGE PLATED!"), (boolean)false), (Range[])new Range[0]));
    }

    @Test
    public void testLinearDiscreteSetUnion() {
        SortedRangeSet result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 10L, 20L, 30L}).linearDiscreteSetUnion(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)100L, (Object[])new Object[]{101L, 102L, 103L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 10L, 20L, 30L, 100L, 101L, 102L, 103L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)100L, (Object[])new Object[]{101L, 102L, 103L}).linearDiscreteSetUnion(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 10L, 20L, 30L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 10L, 20L, 30L, 100L, 101L, 102L, 103L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{3L, 5L, 7L, 9L}).linearDiscreteSetUnion(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)2L, (Object[])new Object[]{4L, 6L, 8L, 10L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[0]).linearDiscreteSetUnion(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)2L, (Object[])new Object[]{4L, 6L, 8L, 10L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 4L, 6L, 8L, 10L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{3L, 5L, 7L, 9L}).linearDiscreteSetUnion(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)2L, (Object[])new Object[0]));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 5L, 7L, 9L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 5L, 7L}).linearDiscreteSetUnion(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)2L, (Object[])new Object[]{3L, 5L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L, 5L, 7L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
        result = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 10L, 11L, 20L, 21L}).linearDiscreteSetUnion(SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 12L, 20L, 21L, 30L}));
        Assertions.assertThat((Object)result).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 10L, 11L, 12L, 20L, 21L, 30L}));
        Assertions.assertThat((boolean)result.isDiscreteSet()).isTrue();
    }

    @Test
    public void testSubtract() {
        Assertions.assertThat((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
        Assertions.assertThat((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isEqualTo((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).complement());
        Assertions.assertThat((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isEqualTo((Object)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assertions.assertThat((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[0]));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isEqualTo((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT))).isEqualTo((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]))).isEqualTo((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}))).isEqualTo((Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}));
        Assertions.assertThat((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]))).isEqualTo((Object)SortedRangeSet.none((Type)BigintType.BIGINT));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        SortedRangeSet set = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.none((Type)DoubleType.DOUBLE);
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"), (Object[])new Object[0]);
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[]{Range.equal((Type)BooleanType.BOOLEAN, (Object)false)});
        Assertions.assertThat((Object)set).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
    }

    @Test
    public void testExpandRangesForDenseType() {
        for (Type type : Arrays.asList(BigintType.BIGINT, IntegerType.INTEGER, SmallintType.SMALLINT, TinyintType.TINYINT, DecimalType.createDecimalType((int)2))) {
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(0)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)ValueSet.none((Type)type).tryExpandRanges(0)).isEqualTo(Optional.of(List.of()));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
            Assertions.assertThat((Optional)ValueSet.of((Type)type, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
            type.getRange().ifPresent(range -> {
                long min = (Long)range.getMin();
                Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)min, (boolean)true, (Object)(min + 3L), (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(min), Long.valueOf(min + 1L), Long.valueOf(min + 2L), Long.valueOf(min + 3L))));
                Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)(min + 4L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(min), Long.valueOf(min + 1L), Long.valueOf(min + 2L), Long.valueOf(min + 3L))));
                Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)(min + 3L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(min), Long.valueOf(min + 1L), Long.valueOf(min + 2L), Long.valueOf(min + 3L))));
                long max = (Long)range.getMax();
                Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)(max - 3L), (boolean)true, (Object)max, (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(max - 3L), Long.valueOf(max - 2L), Long.valueOf(max - 1L), Long.valueOf(max))));
                Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)(max - 4L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(max - 3L), Long.valueOf(max - 2L), Long.valueOf(max - 1L), Long.valueOf(max))));
                Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)(max - 3L)), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(max - 3L), Long.valueOf(max - 2L), Long.valueOf(max - 1L), Long.valueOf(max))));
            });
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(10)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)6L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)6L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)2L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of()));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)false, (Object)3L, (boolean)false), (Range[])new Range[0]).tryExpandRanges(5)).isEqualTo(Optional.of(List.of(Long.valueOf(2L))));
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)ValueSet.of((Type)type, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}).tryExpandRanges(3)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)1L), (Range[])new Range[0]).tryExpandRanges(3)).isEqualTo(Optional.empty());
        }
    }

    @Test
    public void testRangeSetHashcode() {
        Assertions.assertThat((int)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)0L), (Range[])new Range[0]).hashCode()).isNotEqualTo(ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)0L), (Range[])new Range[0]).hashCode());
        Assertions.assertThat((int)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[0]).hashCode()).isNotEqualTo(ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)0L, (boolean)false, (Object)1L, (boolean)false), (Range[])new Range[0]).hashCode());
    }

    private void assertUnion(SortedRangeSet first, SortedRangeSet second, SortedRangeSet expected) {
        Assertions.assertThat((Object)first.union((ValueSet)second)).isEqualTo((Object)expected);
        Assertions.assertThat((Object)first.union((Collection)ImmutableList.of((Object)first, (Object)second))).isEqualTo((Object)expected);
        first.isDiscreteSet();
        second.isDiscreteSet();
        Assertions.assertThat((Comparable)first.getDiscreteSetMarker()).isNotEqualTo((Object)SortedRangeSet.DiscreteSetMarker.UNKNOWN);
        Assertions.assertThat((Comparable)second.getDiscreteSetMarker()).isNotEqualTo((Object)SortedRangeSet.DiscreteSetMarker.UNKNOWN);
        Assertions.assertThat((boolean)first.union((ValueSet)second).isDiscreteSet()).isEqualTo(expected.isDiscreteSet());
    }

    private static SortedRangeSetAssert assertSortedRangeSet(SortedRangeSet sortedRangeSet) {
        return (SortedRangeSetAssert)Assertions.assertThat(() -> new SortedRangeSetAssert(sortedRangeSet));
    }

    private static class SortedRangeSetAssert {
        private final SortedRangeSet sortedRangeSet;

        public SortedRangeSetAssert(SortedRangeSet sortedRangeSet) {
            this.sortedRangeSet = Objects.requireNonNull(sortedRangeSet, "sortedRangeSet is null");
        }

        public SortedRangeSetAssert containsValue(Object value) {
            if (!this.sortedRangeSet.containsValue(value)) {
                throw new AssertionError((Object)String.format("Expected %s to contain %s", this.sortedRangeSet, value));
            }
            return this;
        }

        public SortedRangeSetAssert doesNotContainValue(Object value) {
            if (this.sortedRangeSet.containsValue(value)) {
                throw new AssertionError((Object)String.format("Expected %s not to contain %s", this.sortedRangeSet, value));
            }
            return this;
        }
    }
}

