/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.resourcegroups;

import io.airlift.json.JsonCodec;
import io.trino.spi.resourcegroups.ResourceGroupId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestResourceGroupId {
    @Test
    public void testBasic() {
        new ResourceGroupId("test_test");
        new ResourceGroupId("test.test");
        new ResourceGroupId(new ResourceGroupId("test"), "test");
    }

    @Test
    public void testCodec() {
        JsonCodec codec = JsonCodec.jsonCodec(ResourceGroupId.class);
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("test.test"), "foo");
        Assertions.assertThat((Object)((ResourceGroupId)codec.fromJson(codec.toJson((Object)resourceGroupId)))).isEqualTo((Object)resourceGroupId);
        Assertions.assertThat((String)codec.toJson((Object)resourceGroupId)).isEqualTo("[ \"test.test\", \"foo\" ]");
        Assertions.assertThat((Object)((ResourceGroupId)codec.fromJson("[\"test.test\", \"foo\"]"))).isEqualTo((Object)resourceGroupId);
    }

    @Test
    public void testIsAncestor() {
        ResourceGroupId root = new ResourceGroupId("root");
        ResourceGroupId rootA = new ResourceGroupId(root, "a");
        ResourceGroupId rootAFoo = new ResourceGroupId(rootA, "foo");
        ResourceGroupId rootBar = new ResourceGroupId(root, "bar");
        Assertions.assertThat((boolean)root.isAncestorOf(rootA)).isTrue();
        Assertions.assertThat((boolean)root.isAncestorOf(rootAFoo)).isTrue();
        Assertions.assertThat((boolean)root.isAncestorOf(rootBar)).isTrue();
        Assertions.assertThat((boolean)rootA.isAncestorOf(rootAFoo)).isTrue();
        Assertions.assertThat((boolean)rootA.isAncestorOf(rootBar)).isFalse();
        Assertions.assertThat((boolean)rootAFoo.isAncestorOf(rootBar)).isFalse();
        Assertions.assertThat((boolean)rootBar.isAncestorOf(rootAFoo)).isFalse();
        Assertions.assertThat((boolean)rootAFoo.isAncestorOf(root)).isFalse();
        Assertions.assertThat((boolean)root.isAncestorOf(root)).isFalse();
        Assertions.assertThat((boolean)rootAFoo.isAncestorOf(rootAFoo)).isFalse();
    }
}

