/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIdentity {
    private static final Identity TEST_IDENTITY = Identity.forUser((String)"user").withPrincipal((Principal)new BasicPrincipal("principal")).withGroups((Set)ImmutableSet.of((Object)"group1", (Object)"group2")).withEnabledRoles((Set)ImmutableSet.of((Object)"role1", (Object)"role2")).withConnectorRoles((Map)ImmutableMap.of((Object)"connector1", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("connector1role")), (Object)"connector2", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("connector2role")))).withExtraCredentials((Map)ImmutableMap.of((Object)"extra1", (Object)"credential1")).build();

    @Test
    public void testEquals() {
        Identity otherIdentity = Identity.from((Identity)TEST_IDENTITY).withExtraCredentials((Map)ImmutableMap.of((Object)"extra2", (Object)"credential2")).build();
        Assertions.assertThat((Object)otherIdentity).isEqualTo((Object)TEST_IDENTITY);
    }

    @Test
    public void testNotEquals() {
        Assertions.assertThat((Object)Identity.from((Identity)TEST_IDENTITY).withPrincipal((Principal)new BasicPrincipal("other principal")).build()).isNotEqualTo((Object)TEST_IDENTITY);
        Assertions.assertThat((Object)Identity.from((Identity)TEST_IDENTITY).withPrincipal((Principal)new BasicPrincipal("other principal")).build()).isNotEqualTo((Object)TEST_IDENTITY);
        Assertions.assertThat((Object)Identity.from((Identity)TEST_IDENTITY).withGroups((Set)ImmutableSet.of((Object)"group2", (Object)"group3")).build()).isNotEqualTo((Object)TEST_IDENTITY);
        Assertions.assertThat((Object)Identity.from((Identity)TEST_IDENTITY).withEnabledRoles((Set)ImmutableSet.of((Object)"role2", (Object)"role3")).build()).isNotEqualTo((Object)TEST_IDENTITY);
        Assertions.assertThat((Object)Identity.from((Identity)TEST_IDENTITY).withConnectorRoles((Map)ImmutableMap.of((Object)"connector2", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("connector2role")), (Object)"connector3", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("connector3role")))).build()).isNotEqualTo((Object)TEST_IDENTITY);
    }

    @Test
    public void testHashCode() {
        Identity otherIdentity = Identity.from((Identity)TEST_IDENTITY).withExtraCredentials((Map)ImmutableMap.of((Object)"extra2", (Object)"credential2")).build();
        Assertions.assertThat((int)otherIdentity.hashCode()).isEqualTo(TEST_IDENTITY.hashCode());
    }
}

