/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import java.math.BigDecimal;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDecimals {
    @Test
    public void testParse() {
        this.assertParseResult("0", 0L, 1, 0);
        this.assertParseResult("0.", 0L, 1, 0);
        this.assertParseResult(".0", 0L, 1, 1);
        this.assertParseResult("+0", 0L, 1, 0);
        this.assertParseResult("-0", 0L, 1, 0);
        this.assertParseResult("000", 0L, 1, 0);
        this.assertParseResult("+000", 0L, 1, 0);
        this.assertParseResult("-000", 0L, 1, 0);
        this.assertParseResult("0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("+0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("-0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("1.1", 11L, 2, 1);
        this.assertParseResult("1.", 1L, 1, 0);
        this.assertParseResult("+1.1", 11L, 2, 1);
        this.assertParseResult("+1.", 1L, 1, 0);
        this.assertParseResult("-1.1", -11L, 2, 1);
        this.assertParseResult("-1.", -1L, 1, 0);
        this.assertParseResult("0001.1", 11L, 2, 1);
        this.assertParseResult("+0001.1", 11L, 2, 1);
        this.assertParseResult("-0001.1", -11L, 2, 1);
        this.assertParseResult("0.1", 1L, 1, 1);
        this.assertParseResult(".1", 1L, 1, 1);
        this.assertParseResult("+0.1", 1L, 1, 1);
        this.assertParseResult("+.1", 1L, 1, 1);
        this.assertParseResult("-0.1", -1L, 1, 1);
        this.assertParseResult("-.1", -1L, 1, 1);
        this.assertParseResult(".1", 1L, 1, 1);
        this.assertParseResult("+.1", 1L, 1, 1);
        this.assertParseResult("-.1", -1L, 1, 1);
        this.assertParseResult("000.1", 1L, 1, 1);
        this.assertParseResult("+000.1", 1L, 1, 1);
        this.assertParseResult("-000.1", -1L, 1, 1);
        this.assertParseResult("12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-12345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-00012345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-0.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-000.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("12345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+12345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-12345678901234567890.123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("00012345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+00012345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-00012345678901234567890.123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("0.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0.12345678901234567890123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult(".12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-.12345678901234567890123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("0000.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0000.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0000.12345678901234567890123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("0_1_2_3_4", 1234L, 4, 0);
        this.assertParseFailure("0_1_2_3_4_");
        this.assertParseFailure("_0_1_2_3_4");
        this.assertParseResult("0_1_2_3_4.5_6_7_8", 12345678L, 8, 4);
        this.assertParseFailure("_0_1_2_3_4.5_6_7_8");
        this.assertParseFailure("0_1_2_3_4_.5_6_7_8");
        this.assertParseFailure("0_1_2_3_4._5_6_7_8");
        this.assertParseFailure("0_1_2_3_4.5_6_7_8_");
    }

    @Test
    public void testRejectNoDigits() {
        this.assertParseFailure(".");
        this.assertParseFailure("+.");
        this.assertParseFailure("-.");
    }

    @Test
    public void testEncodeShortScaledValue() {
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2.00"), (int)2)).isEqualTo(200L);
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2.13"), (int)2)).isEqualTo(213L);
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("172.60"), (int)2)).isEqualTo(17260L);
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2"), (int)2)).isEqualTo(200L);
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("172.6"), (int)2)).isEqualTo(17260L);
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2.00"), (int)2)).isEqualTo(-200L);
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2.13"), (int)2)).isEqualTo(-213L);
        Assertions.assertThat((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2"), (int)2)).isEqualTo(-200L);
    }

    @Test
    public void testEncodeScaledValue() {
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2.00"), (int)2)).isEqualTo((Object)Int128.valueOf((long)200L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2.13"), (int)2)).isEqualTo((Object)Int128.valueOf((long)213L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("172.60"), (int)2)).isEqualTo((Object)Int128.valueOf((long)17260L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2"), (int)2)).isEqualTo((Object)Int128.valueOf((long)200L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("172.6"), (int)2)).isEqualTo((Object)Int128.valueOf((long)17260L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2.00"), (int)2)).isEqualTo((Object)Int128.valueOf((long)-200L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2.13"), (int)2)).isEqualTo((Object)Int128.valueOf((long)-213L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2"), (int)2)).isEqualTo((Object)Int128.valueOf((long)-200L));
        Assertions.assertThat((Comparable)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-172.60"), (int)2)).isEqualTo((Object)Int128.valueOf((long)-17260L));
    }

    @Test
    public void testOverflows() {
        Assertions.assertThat((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"100"), (int)2)).isTrue();
        Assertions.assertThat((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"-100"), (int)2)).isTrue();
        Assertions.assertThat((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"99"), (int)2)).isFalse();
        Assertions.assertThat((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"-99"), (int)2)).isFalse();
    }

    private void assertParseResult(String value, Object expectedObject, int expectedPrecision, int expectedScale) {
        Assertions.assertThat((Object)Decimals.parse((String)value)).isEqualTo((Object)new DecimalParseResult(expectedObject, DecimalType.createDecimalType((int)expectedPrecision, (int)expectedScale)));
    }

    private void assertParseFailure(String text) {
        try {
            Decimals.parse((String)text);
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = String.format("Invalid DECIMAL value '%s'", text);
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).withFailMessage(() -> String.format("Unexpected exception, exception with message '%s' was expected", expectedMessage))).isEqualTo(expectedMessage);
            return;
        }
        throw new AssertionError((Object)"Parse failure was expected");
    }
}

