/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.google.common.base.Throwables;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.LongDecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLongDecimalType {
    private static final LongDecimalType TYPE = (LongDecimalType)LongDecimalType.createDecimalType((int)20, (int)10);
    private static final MethodHandle TYPE_COMPARISON = new TypeOperators().getComparisonUnorderedLastOperator((Type)TYPE, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));

    @Test
    public void testCompareTo() {
        this.testCompare("0", "-1234567891.1234567890", 1);
        this.testCompare("1234567890.1234567890", "1234567890.1234567890", 0);
        this.testCompare("1234567890.1234567890", "1234567890.1234567891", -1);
        this.testCompare("1234567890.1234567890", "1234567890.1234567889", 1);
        this.testCompare("1234567890.1234567890", "1234567891.1234567890", -1);
        this.testCompare("1234567890.1234567890", "1234567889.1234567890", 1);
        this.testCompare("0", "1234567891.1234567890", -1);
        this.testCompare("1234567890.1234567890", "0", 1);
        this.testCompare("0", "0", 0);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567890", 0);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567891", 1);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567889", -1);
        this.testCompare("-1234567890.1234567890", "-1234567891.1234567890", 1);
        this.testCompare("-1234567890.1234567890", "-1234567889.1234567890", -1);
        this.testCompare("0", "-1234567891.1234567890", 1);
        this.testCompare("-1234567890.1234567890", "0", -1);
        this.testCompare("-1234567890.1234567890", "1234567890.1234567890", -1);
        this.testCompare("1234567890.1234567890", "-1234567890.1234567890", 1);
    }

    private void testCompare(String decimalA, String decimalB, int expected) {
        try {
            long actual = TYPE_COMPARISON.invokeExact(this.decimalAsBlock(decimalA), 0, this.decimalAsBlock(decimalB), 0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)((int)Math.signum(actual))).describedAs("bad comparison result for " + decimalA + ", " + decimalB, new Object[0])).isEqualTo((int)Math.signum(expected));
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private Block decimalAsBlock(String value) {
        Int128 decimal = Decimals.valueOf((BigDecimal)new BigDecimal(value));
        Int128ArrayBlockBuilder blockBuilder = new Int128ArrayBlockBuilder(null, 1);
        TYPE.writeObject((BlockBuilder)blockBuilder, (Object)decimal);
        return blockBuilder.build();
    }
}

