/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.SqlVarbinary;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSqlVarbinary {
    @Test
    public void testToString() {
        for (int lines = 0; lines < 5; ++lines) {
            for (int lastLineBytes = 0; lastLineBytes < 32; ++lastLineBytes) {
                byte[] bytes = TestSqlVarbinary.createBytes(lines, lastLineBytes);
                String expected = TestSqlVarbinary.simpleToString(bytes);
                Assertions.assertThat((String)expected).isEqualTo(new SqlVarbinary(bytes).toString());
            }
        }
    }

    private static String simpleToString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                if (i % 32 == 0) {
                    builder.append("\n");
                } else if (i % 8 == 0) {
                    builder.append("   ");
                } else {
                    builder.append(" ");
                }
            }
            builder.append(String.format("%02x", bytes[i] & 0xFF));
        }
        return builder.toString();
    }

    private static byte[] createBytes(int lines, int lastLineLength) {
        byte[] bytes = new byte[lines * 32 + lastLineLength];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }
}

