/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestTypeOperators {
    TestTypeOperators() {
    }

    @Test
    void testIdenticalGenerator() throws Throwable {
        TypeOperators typeOperators = new TypeOperators();
        ImmutableList argumentConventions = ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, (Object)InvocationConvention.InvocationArgumentConvention.FLAT);
        List<Long> testArguments = Arrays.asList(0L, 1L, 2L, null);
        for (InvocationConvention.InvocationArgumentConvention leftConvention : argumentConventions) {
            for (InvocationConvention.InvocationArgumentConvention rightConvention : argumentConventions) {
                MethodHandle operator = typeOperators.getIdenticalOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{leftConvention, rightConvention}));
                operator = MethodHandles.exactInvoker(operator.type()).bindTo(operator);
                for (Long leftArgument : testArguments) {
                    for (Long rightArgument : testArguments) {
                        if (!leftConvention.isNullable() && leftArgument == null || !rightConvention.isNullable() && rightArgument == null) continue;
                        boolean expected = Objects.equals(leftArgument, rightArgument);
                        ArrayList<Object> arguments = new ArrayList<Object>();
                        TestTypeOperators.addCallArgument(typeOperators, leftConvention, leftArgument, arguments);
                        TestTypeOperators.addCallArgument(typeOperators, rightConvention, rightArgument, arguments);
                        boolean actual = (Boolean)operator.invokeWithArguments(arguments);
                        Assertions.assertThat((boolean)actual).isEqualTo(expected);
                    }
                }
            }
        }
    }

    private static void addCallArgument(TypeOperators typeOperators, InvocationConvention.InvocationArgumentConvention convention, Long value, List<Object> callArguments) throws Throwable {
        switch (convention) {
            case NEVER_NULL: 
            case BOXED_NULLABLE: {
                callArguments.add(value);
                break;
            }
            case NULL_FLAG: {
                callArguments.add(value == null ? 0L : value);
                callArguments.add(value == null);
                break;
            }
            case BLOCK_POSITION: 
            case BLOCK_POSITION_NOT_NULL: {
                BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1);
                if (value == null) {
                    Verify.verify((convention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION ? 1 : 0) != 0);
                    blockBuilder.appendNull();
                } else {
                    BigintType.BIGINT.writeLong(blockBuilder, value.longValue());
                }
                callArguments.add(blockBuilder.build());
                callArguments.add(0);
                break;
            }
            case FLAT: {
                Verify.verify((value != null ? 1 : 0) != 0);
                byte[] fixedSlice = new byte[BigintType.BIGINT.getFlatFixedSize()];
                MethodHandle writeFlat = typeOperators.getReadValueOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
                writeFlat.invoke(value, fixedSlice, 0, new byte[0], 0);
                callArguments.add(fixedSlice);
                callArguments.add(0);
                callArguments.add(new byte[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

