/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.spi.type;

import java.util.List;

public class QuantileDigestParametricType
        implements ParametricType
{
    public static final QuantileDigestParametricType QDIGEST = new QuantileDigestParametricType();

    @Override
    public String getName()
    {
        return StandardTypes.QDIGEST;
    }

    @Override
    public Type createType(TypeManager typeManager, List<TypeParameter> parameters)
    {
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("QDIGEST type expects exactly one type as a parameter, got " + parameters);
        }
        if (parameters.get(0).getKind() != ParameterKind.TYPE) {
            throw new IllegalArgumentException("QDIGEST expects type as a parameter, got " + parameters);
        }
        // Validation check on the acceptable type (bigint, real, double) intentionally omitted
        // because this is validated in each function and to allow for consistent error messaging
        return new QuantileDigestType(parameters.get(0).getType());
    }
}
