/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public final class LongArrayBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(LongArrayBlock.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 9;
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final long[] values;
    private final long retainedSizeInBytes;

    public LongArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, long[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    LongArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, long[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((long[])values);
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(9);
    }

    @Override
    public long getSizeInBytes() {
        return 9L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 9L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        return 9L * (long)selectedPositionsCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 8L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((long[])this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public long getLong(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.values[position + this.arrayOffset];
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public LongArrayBlock getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new LongArrayBlock(0, 1, blArray, new long[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public LongArrayBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        long[] newValues = new long[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new LongArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public LongArrayBlock getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new LongArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public LongArrayBlock copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.arrayOffset, length);
        long[] newValues = BlockUtil.compactArray(this.values, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new LongArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public LongArrayBlock copyWithAppendedNull() {
        boolean[] newValueIsNull = BlockUtil.copyIsNullAndAppendNull(this.valueIsNull, this.arrayOffset, this.positionCount);
        long[] newValues = BlockUtil.ensureCapacity(this.values, this.arrayOffset + this.positionCount + 1);
        return new LongArrayBlock(this.arrayOffset, this.positionCount + 1, newValueIsNull, newValues);
    }

    @Override
    public LongArrayBlock getUnderlyingValueBlock() {
        return this;
    }

    public String toString() {
        return "LongArrayBlock{positionCount=" + this.getPositionCount() + "}";
    }

    @Override
    public Optional<ByteArrayBlock> getNulls() {
        return BlockUtil.getNulls(this.valueIsNull, this.arrayOffset, this.positionCount);
    }

    int getRawValuesOffset() {
        return this.arrayOffset;
    }

    long[] getRawValues() {
        return this.values;
    }

    boolean[] getRawValueIsNull() {
        return this.valueIsNull;
    }
}

