/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.Fixed12BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Optional;

final class LongTimestampWithTimeZoneType
extends TimestampWithTimeZoneType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongTimestampWithTimeZoneType.class, MethodHandles.lookup(), LongTimestampWithTimeZone.class);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);

    public LongTimestampWithTimeZoneType(int precision) {
        super(precision, LongTimestampWithTimeZone.class, Fixed12Block.class);
        if (precision < 4 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [%s, %s]", 4, 12));
        }
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 12;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Fixed12BlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Fixed12BlockBuilder(null, positionCount);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            Fixed12Block valueBlock = (Fixed12Block)block.getUnderlyingValueBlock();
            int valuePosition = block.getUnderlyingValuePosition(position);
            LongTimestampWithTimeZoneType.write(blockBuilder, LongTimestampWithTimeZoneType.getPackedEpochMillis(valueBlock, valuePosition), LongTimestampWithTimeZoneType.getPicosOfMilli(valueBlock, valuePosition));
        }
    }

    @Override
    public Object getObject(Block block, int position) {
        Fixed12Block valueBlock = (Fixed12Block)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(valueBlock, valuePosition);
        int picosOfMilli = LongTimestampWithTimeZoneType.getPicosOfMilli(valueBlock, valuePosition);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction(DateTimeEncoding.unpackMillisUtc(packedEpochMillis), picosOfMilli, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)value;
        LongTimestampWithTimeZoneType.write(blockBuilder, DateTimeEncoding.packDateTimeWithZone(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()), timestamp.getPicosOfMilli());
    }

    private static void write(BlockBuilder blockBuilder, long packedDateTimeWithZone, int picosOfMilli) {
        ((Fixed12BlockBuilder)blockBuilder).writeFixed12(packedDateTimeWithZone, picosOfMilli);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Fixed12Block valueBlock = (Fixed12Block)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(valueBlock, valuePosition);
        int picosOfMilli = LongTimestampWithTimeZoneType.getPicosOfMilli(valueBlock, valuePosition);
        return SqlTimestampWithTimeZone.newInstance(this.getPrecision(), DateTimeEncoding.unpackMillisUtc(packedEpochMillis), picosOfMilli, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    @Override
    public int getFlatFixedSize() {
        return 12;
    }

    @Override
    public Optional<Object> getPreviousValue(Object value) {
        LongTimestampWithTimeZone timestampWithTimeZone = (LongTimestampWithTimeZone)value;
        long epochMillis = timestampWithTimeZone.getEpochMillis();
        int picosOfMilli = timestampWithTimeZone.getPicosOfMilli();
        if ((picosOfMilli -= Math.toIntExact(Timestamps.rescale(1L, 0, 12 - this.getPrecision()))) < 0) {
            if (epochMillis == Long.MIN_VALUE) {
                return Optional.empty();
            }
            --epochMillis;
            picosOfMilli += 1000000000;
        }
        return Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction(epochMillis, picosOfMilli, TimeZoneKey.UTC_KEY));
    }

    @Override
    public Optional<Object> getNextValue(Object value) {
        LongTimestampWithTimeZone timestampWithTimeZone = (LongTimestampWithTimeZone)value;
        long epochMillis = timestampWithTimeZone.getEpochMillis();
        int picosOfMilli = timestampWithTimeZone.getPicosOfMilli();
        if ((picosOfMilli += Math.toIntExact(Timestamps.rescale(1L, 0, 12 - this.getPrecision()))) >= 1000000000) {
            if (epochMillis == Long.MAX_VALUE) {
                return Optional.empty();
            }
            ++epochMillis;
            picosOfMilli -= 1000000000;
        }
        return Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction(epochMillis, picosOfMilli, TimeZoneKey.UTC_KEY));
    }

    private static long getPackedEpochMillis(Fixed12Block block, int position) {
        return block.getFixed12First(position);
    }

    private static long getEpochMillis(Fixed12Block block, int position) {
        return DateTimeEncoding.unpackMillisUtc(LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position));
    }

    private static int getPicosOfMilli(Fixed12Block block, int position) {
        return block.getFixed12Second(position);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static LongTimestampWithTimeZone readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        long packedEpochMillis = LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        int picosOfMilli = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 8);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction(DateTimeEncoding.unpackMillisUtc(packedEpochMillis), picosOfMilli, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void readFlatToBlock(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, BlockBuilder blockBuilder) {
        LongTimestampWithTimeZoneType.write(blockBuilder, LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset), INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 8));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(LongTimestampWithTimeZone value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset, DateTimeEncoding.packDateTimeWithZone(value.getEpochMillis(), value.getTimeZoneKey()));
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 8, value.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeBlockFlat(@BlockPosition Fixed12Block block, @BlockIndex int position, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset, LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position));
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 8, LongTimestampWithTimeZoneType.getPicosOfMilli(block, position));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.equal(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Fixed12Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Fixed12Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.equal(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static boolean equal(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis == rightEpochMillis && leftPicosOfMilli == rightPicosOfMilli;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(LongTimestampWithTimeZone value) {
        return LongTimestampWithTimeZoneType.xxHash64(value.getEpochMillis(), value.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Fixed12Block block, @BlockIndex int position) {
        return LongTimestampWithTimeZoneType.xxHash64(LongTimestampWithTimeZoneType.getEpochMillis(block, position), LongTimestampWithTimeZoneType.getPicosOfMilli(block, position));
    }

    private static long xxHash64(long epochMillis, int picosOfMilli) {
        return XxHash64.hash((long)epochMillis) ^ XxHash64.hash((long)picosOfMilli);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.comparison(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Fixed12Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Fixed12Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.comparison(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static int comparison(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        int value = Long.compare(leftEpochMillis, rightEpochMillis);
        if (value != 0) {
            return value;
        }
        return Integer.compare(leftPicosOfMilli, rightPicosOfMilli);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.lessThan(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(@BlockPosition Fixed12Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Fixed12Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.lessThan(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static boolean lessThan(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis < rightEpochMillis || leftEpochMillis == rightEpochMillis && leftPicosOfMilli < rightPicosOfMilli;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.lessThanOrEqual(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(@BlockPosition Fixed12Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Fixed12Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.lessThanOrEqual(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static boolean lessThanOrEqual(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis < rightEpochMillis || leftEpochMillis == rightEpochMillis && leftPicosOfMilli <= rightPicosOfMilli;
    }
}

