/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;

final class ShortDecimalType
extends DecimalType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(ShortDecimalType.class, MethodHandles.lookup(), Long.TYPE);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final ShortDecimalType[][] INSTANCES = new ShortDecimalType[18][19];
    private final Type.Range range;

    static ShortDecimalType getInstance(int precision, int scale) {
        return INSTANCES[precision - 1][scale];
    }

    private ShortDecimalType(int precision, int scale) {
        super(precision, scale, Long.TYPE, LongArrayBlock.class);
        ShortDecimalType.checkArgument(0 < precision && precision <= 18, "Invalid precision: %s", precision);
        ShortDecimalType.checkArgument(0 <= scale && scale <= precision, "Invalid scale for precision %s: %s", precision, scale);
        long max = Decimals.longTenToNth(precision) - 1L;
        this.range = new Type.Range(-max, max);
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 8;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlDecimal(BigInteger.valueOf(this.getLong(block, position)), this.getPrecision(), this.getScale());
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeLong(blockBuilder, this.getLong(block, position));
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return ShortDecimalType.read((LongArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        ((LongArrayBlockBuilder)blockBuilder).writeLong(value);
    }

    @Override
    public int getFlatFixedSize() {
        return 8;
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(this.range);
    }

    @Override
    public Optional<Stream<?>> getDiscreteValues(Type.Range range) {
        return Optional.of(LongStream.rangeClosed((Long)range.getMin(), (Long)range.getMax()).boxed());
    }

    @Override
    public Optional<Object> getPreviousValue(Object object) {
        long value = (Long)object;
        if ((Long)this.range.getMin() == value) {
            return Optional.empty();
        }
        return Optional.of(value - 1L);
    }

    @Override
    public Optional<Object> getNextValue(Object object) {
        long value = (Long)object;
        if ((Long)this.range.getMax() == value) {
            return Optional.empty();
        }
        return Optional.of(value + 1L);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long read(@BlockPosition LongArrayBlock block, @BlockIndex int position) {
        return block.getLong(position);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        return LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(long value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset, value);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        return AbstractLongType.hash(value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Long.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return left <= right;
    }

    static {
        for (int precision = 1; precision <= 18; ++precision) {
            for (int scale = 0; scale <= precision; ++scale) {
                ShortDecimalType.INSTANCES[precision - 1][scale] = new ShortDecimalType(precision, scale);
            }
        }
    }
}

