/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import java.util.Arrays;
import java.util.Base64;
import java.util.HexFormat;
import java.util.Objects;

public final class SqlVarbinary
implements Comparable<SqlVarbinary> {
    private static final HexFormat HEX_FORMAT = HexFormat.of().withDelimiter(" ");
    private static final String WORD_SEPARATOR = "   ";
    private static final int OUTPUT_CHARS_PER_FULL_WORD = 23;
    private final byte[] bytes;

    public SqlVarbinary(byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes, "bytes is null");
    }

    @Override
    public int compareTo(SqlVarbinary obj) {
        return Arrays.compare(this.bytes, obj.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlVarbinary other = (SqlVarbinary)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    public String toHexString() {
        if (this.bytes.length == 0) {
            return "";
        }
        int fullLineCount = this.bytes.length / 32;
        int lastLineBytes = this.bytes.length % 32;
        long totalSize = (long)fullLineCount * (long)(92 + 3 * WORD_SEPARATOR.length() + 1);
        if (lastLineBytes == 0) {
            --totalSize;
        } else {
            int lastLineWords = lastLineBytes / 8;
            totalSize += (long)lastLineWords * (long)(23 + WORD_SEPARATOR.length());
            if (lastLineWords * 8 == lastLineBytes) {
                totalSize -= (long)WORD_SEPARATOR.length();
            } else {
                int lastWordBytes = lastLineBytes % 8;
                totalSize += 2L * (long)lastWordBytes + (long)(lastWordBytes - 1);
            }
        }
        StringBuilder builder = new StringBuilder(Math.toIntExact(totalSize));
        int index = 0;
        for (int i = 0; i < fullLineCount; ++i) {
            if (i != 0) {
                builder.append("\n");
            }
            HEX_FORMAT.formatHex(builder, this.bytes, index, index + 8);
            builder.append(WORD_SEPARATOR);
            HEX_FORMAT.formatHex(builder, this.bytes, index += 8, index + 8);
            builder.append(WORD_SEPARATOR);
            HEX_FORMAT.formatHex(builder, this.bytes, index += 8, index + 8);
            builder.append(WORD_SEPARATOR);
            HEX_FORMAT.formatHex(builder, this.bytes, index += 8, index + 8);
            index += 8;
        }
        if (lastLineBytes > 0) {
            if (fullLineCount > 0) {
                builder.append("\n");
            }
            boolean firstWord = true;
            while (index < this.bytes.length) {
                if (!firstWord) {
                    builder.append(WORD_SEPARATOR);
                }
                firstWord = false;
                int length = Math.min(8, this.bytes.length - index);
                HEX_FORMAT.formatHex(builder, this.bytes, index, index + length);
                index += length;
            }
        }
        return builder.toString();
    }
}

