/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public final class RowBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RowBlock.class);
    private final int positionCount;
    @Nullable
    private final boolean[] rowIsNull;
    private final Block[] fieldBlocks;
    private final List<Block> fieldBlocksList;
    private final int fixedSizePerRow;
    private volatile long sizeInBytes = -1L;

    public static RowBlock fromFieldBlocks(int positionCount, Block[] fieldBlocks) {
        return RowBlock.createRowBlockInternal(positionCount, null, fieldBlocks);
    }

    public static RowBlock fromNotNullSuppressedFieldBlocks(int positionCount, Optional<boolean[]> rowIsNullOptional, Block[] fieldBlocks) {
        if (rowIsNullOptional.isPresent()) {
            boolean[] rowIsNull = rowIsNullOptional.get();
            BlockUtil.checkArrayRange(rowIsNull, 0, positionCount);
            for (int fieldIndex = 0; fieldIndex < fieldBlocks.length; ++fieldIndex) {
                LazyBlock lazyBlock;
                Block field = fieldBlocks[fieldIndex];
                if (field instanceof LazyBlock && !(lazyBlock = (LazyBlock)field).isLoaded()) continue;
                for (int position = 0; position < positionCount; ++position) {
                    if (!rowIsNull[position] || field.isNull(position)) continue;
                    throw new IllegalArgumentException(String.format("Field value for null row must be null: field %s, position %s", fieldIndex, position));
                }
            }
        }
        return RowBlock.createRowBlockInternal(positionCount, rowIsNullOptional.orElse(null), fieldBlocks);
    }

    static RowBlock createRowBlockInternal(int positionCount, @Nullable boolean[] rowIsNull, Block[] fieldBlocks) {
        int fixedSize = 1;
        for (Block fieldBlock : fieldBlocks) {
            OptionalInt fieldFixedSize = fieldBlock.fixedSizeInBytesPerPosition();
            if (fieldFixedSize.isEmpty()) {
                fixedSize = -1;
                break;
            }
            fixedSize += fieldFixedSize.getAsInt();
        }
        return new RowBlock(positionCount, rowIsNull, fieldBlocks, fixedSize);
    }

    private RowBlock(int positionCount, @Nullable boolean[] rowIsNull, Block[] fieldBlocks, int fixedSizePerRow) {
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (rowIsNull != null && rowIsNull.length < positionCount) {
            throw new IllegalArgumentException("rowIsNull length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlocks, "fieldBlocks is null");
        if (fieldBlocks.length == 0) {
            throw new IllegalArgumentException("Row block must contain at least one field");
        }
        for (int i = 0; i < fieldBlocks.length; ++i) {
            if (positionCount == fieldBlocks[i].getPositionCount()) continue;
            throw new IllegalArgumentException("Expected field %s to have %s positions but has %s positions".formatted(i, positionCount, fieldBlocks[i].getPositionCount()));
        }
        this.positionCount = positionCount;
        this.rowIsNull = positionCount == 0 ? null : rowIsNull;
        this.fieldBlocks = fieldBlocks;
        this.fieldBlocksList = List.of(fieldBlocks);
        this.fixedSizePerRow = fixedSizePerRow;
    }

    Block[] getRawFieldBlocks() {
        return this.fieldBlocks;
    }

    public List<Block> getFieldBlocks() {
        return this.fieldBlocksList;
    }

    public Block getFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex];
    }

    @Override
    public boolean mayHaveNull() {
        return this.rowIsNull != null;
    }

    @Override
    public boolean hasNull() {
        if (this.rowIsNull == null) {
            return false;
        }
        for (int i = 0; i < this.positionCount; ++i) {
            if (!this.rowIsNull[i]) continue;
            return true;
        }
        return false;
    }

    boolean[] getRawRowIsNull() {
        return this.rowIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes >= 0L) {
            return this.sizeInBytes;
        }
        long sizeInBytes = 1L * (long)this.positionCount;
        boolean hasUnloadedBlocks = false;
        for (Block fieldBlock : this.fieldBlocks) {
            sizeInBytes += fieldBlock.getSizeInBytes();
            hasUnloadedBlocks = hasUnloadedBlocks || !fieldBlock.isLoaded();
        }
        if (!hasUnloadedBlocks) {
            this.sizeInBytes = sizeInBytes;
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.rowIsNull);
        for (Block fieldBlock : this.fieldBlocks) {
            retainedSizeInBytes += fieldBlock.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (Block fieldBlock : this.fieldBlocks) {
            consumer.accept(fieldBlock, fieldBlock.getRetainedSizeInBytes());
        }
        if (this.rowIsNull != null) {
            consumer.accept(this.rowIsNull, SizeOf.sizeOf((boolean[])this.rowIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    public String toString() {
        return String.format("RowBlock{fieldCount=%d, positionCount=%d}", this.fieldBlocks.length, this.positionCount);
    }

    @Override
    public boolean isLoaded() {
        for (Block fieldBlock : this.fieldBlocks) {
            if (fieldBlock.isLoaded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Block getLoadedBlock() {
        Block[] loadedFieldBlocks = BlockUtil.ensureBlocksAreLoaded(this.fieldBlocks);
        if (loadedFieldBlocks == this.fieldBlocks) {
            return this;
        }
        return new RowBlock(this.positionCount, this.rowIsNull, loadedFieldBlocks, this.fixedSizePerRow);
    }

    @Override
    public RowBlock copyWithAppendedNull() {
        boolean[] newRowIsNull = this.rowIsNull != null ? Arrays.copyOf(this.rowIsNull, this.positionCount + 1) : new boolean[this.positionCount + 1];
        newRowIsNull[this.positionCount] = true;
        Block[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].copyWithAppendedNull();
        }
        return new RowBlock(this.positionCount + 1, newRowIsNull, newBlocks, this.fixedSizePerRow);
    }

    @Override
    public RowBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        Block[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < newBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].copyPositions(positions, offset, length);
        }
        boolean[] newRowIsNull = null;
        if (this.rowIsNull != null) {
            newRowIsNull = new boolean[length];
            for (int i = 0; i < length; ++i) {
                newRowIsNull[i] = this.rowIsNull[positions[offset + i]];
            }
        }
        return new RowBlock(length, newRowIsNull, newBlocks, this.fixedSizePerRow);
    }

    @Override
    public RowBlock getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        boolean[] newRowIsNull = this.rowIsNull == null ? null : BlockUtil.compactArray(this.rowIsNull, positionOffset, length);
        Block[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < newBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].getRegion(positionOffset, length);
        }
        return new RowBlock(length, newRowIsNull, newBlocks, this.fixedSizePerRow);
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return this.fixedSizePerRow > 0 ? OptionalInt.of(this.fixedSizePerRow) : OptionalInt.empty();
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        BlockUtil.checkValidRegion(this.positionCount, position, length);
        long regionSizeInBytes = 1L * (long)length;
        for (Block fieldBlock : this.fieldBlocks) {
            regionSizeInBytes += fieldBlock.getRegionSizeInBytes(position, length);
        }
        return regionSizeInBytes;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedRowPositions) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        if (selectedRowPositions == 0) {
            return 0L;
        }
        if (selectedRowPositions == this.positionCount) {
            return this.getSizeInBytes();
        }
        if (this.fixedSizePerRow > 0) {
            return (long)this.fixedSizePerRow * (long)selectedRowPositions;
        }
        long sizeInBytes = 1L * (long)selectedRowPositions;
        for (Block fieldBlock : this.fieldBlocks) {
            sizeInBytes += fieldBlock.getPositionsSizeInBytes(positions, selectedRowPositions);
        }
        return sizeInBytes;
    }

    @Override
    public RowBlock copyRegion(int positionOffset, int length) {
        boolean[] newRowIsNull;
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        Object[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].copyRegion(positionOffset, length);
        }
        boolean[] blArray = newRowIsNull = this.rowIsNull == null ? null : BlockUtil.compactArray(this.rowIsNull, positionOffset, length);
        if (newRowIsNull == this.rowIsNull && BlockUtil.arraySame(newBlocks, this.fieldBlocks)) {
            return this;
        }
        return new RowBlock(length, newRowIsNull, (Block[])newBlocks, this.fixedSizePerRow);
    }

    public SqlRow getRow(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            throw new IllegalStateException("Position is null");
        }
        return new SqlRow(position, this.fieldBlocks);
    }

    @Override
    public RowBlock getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        Block[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].getSingleValueBlock(position);
        }
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        boolean[] newRowIsNull = blArray;
        return new RowBlock(1, newRowIsNull, newBlocks, this.fixedSizePerRow);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            return 0L;
        }
        long size = 0L;
        for (Block fieldBlock : this.fieldBlocks) {
            size += fieldBlock.getEstimatedDataSizeForStats(position);
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.rowIsNull != null && this.rowIsNull[position];
    }

    public static List<Block> getRowFieldsFromBlock(Block block) {
        if (block instanceof LazyBlock) {
            LazyBlock lazyBlock = (LazyBlock)block;
            block = lazyBlock.getBlock();
        }
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
            RowBlock rowBlock = (RowBlock)runLengthEncodedBlock.getValue();
            return rowBlock.fieldBlocksList.stream().map(fieldBlock -> RunLengthEncodedBlock.create(fieldBlock, runLengthEncodedBlock.getPositionCount())).toList();
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            RowBlock rowBlock = (RowBlock)dictionaryBlock.getDictionary();
            return rowBlock.fieldBlocksList.stream().map(dictionaryBlock::createProjection).toList();
        }
        if (block instanceof RowBlock) {
            return ((RowBlock)block).getFieldBlocks();
        }
        throw new IllegalArgumentException("Unexpected block type: " + block.getClass().getSimpleName());
    }

    public static List<Block> getNullSuppressedRowFieldsFromBlock(Block block) {
        if (block instanceof LazyBlock) {
            LazyBlock lazyBlock = (LazyBlock)block;
            block = lazyBlock.getBlock();
        }
        if (!block.mayHaveNull()) {
            return RowBlock.getRowFieldsFromBlock(block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
            RowBlock rowBlock = (RowBlock)runLengthEncodedBlock.getValue();
            if (!rowBlock.isNull(0)) {
                throw new IllegalStateException("Expected run length encoded block value to be null");
            }
            return rowBlock.fieldBlocksList.stream().map(fieldBlock -> fieldBlock.getRegion(0, 0)).toList();
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            int[] newIds = new int[dictionaryBlock.getPositionCount()];
            int idCount = 0;
            for (int position = 0; position < newIds.length; ++position) {
                if (dictionaryBlock.isNull(position)) continue;
                newIds[idCount] = dictionaryBlock.getId(position);
                ++idCount;
            }
            int nonNullPositionCount = idCount;
            RowBlock rowBlock = (RowBlock)dictionaryBlock.getDictionary();
            return rowBlock.fieldBlocksList.stream().map(field -> DictionaryBlock.create(nonNullPositionCount, field, newIds)).toList();
        }
        if (block instanceof RowBlock) {
            RowBlock rowBlock = (RowBlock)block;
            int[] nonNullPositions = new int[rowBlock.getPositionCount()];
            int idCount = 0;
            for (int position = 0; position < nonNullPositions.length; ++position) {
                if (rowBlock.isNull(position)) continue;
                nonNullPositions[idCount] = position;
                ++idCount;
            }
            int nonNullPositionCount = idCount;
            return rowBlock.fieldBlocksList.stream().map(field -> DictionaryBlock.create(nonNullPositionCount, field, nonNullPositions)).toList();
        }
        throw new IllegalArgumentException("Unexpected block type: " + block.getClass().getSimpleName());
    }

    @Override
    public RowBlock getUnderlyingValueBlock() {
        return this;
    }

    @Override
    public Optional<ByteArrayBlock> getNulls() {
        return BlockUtil.getNulls(this.rowIsNull, 0, this.positionCount);
    }
}

