/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public final class VariableWidthBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(VariableWidthBlock.class);
    private final int arrayOffset;
    private final int positionCount;
    private final Slice slice;
    private final int[] offsets;
    @Nullable
    private final boolean[] valueIsNull;
    private final long retainedSizeInBytes;
    private final long sizeInBytes;

    public VariableWidthBlock(int positionCount, Slice slice, int[] offsets, Optional<boolean[]> valueIsNull) {
        this(0, positionCount, slice, offsets, valueIsNull.orElse(null));
    }

    VariableWidthBlock(int arrayOffset, int positionCount, Slice slice, int[] offsets, boolean[] valueIsNull) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (slice == null) {
            throw new IllegalArgumentException("slice is null");
        }
        this.slice = slice;
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        this.offsets = offsets;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = (long)(offsets[arrayOffset + positionCount] - offsets[arrayOffset]) + 5L * (long)positionCount;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + slice.getRetainedSize() + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((int[])offsets);
    }

    public Slice getRawSlice() {
        return this.slice;
    }

    public int getRawSliceOffset(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getPositionOffset(position);
    }

    int getPositionOffset(int position) {
        return this.offsets[position + this.arrayOffset];
    }

    public int getSliceLength(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getPositionOffset(position + 1) - this.getPositionOffset(position);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return (long)(this.offsets[this.arrayOffset + position + length] - this.offsets[this.arrayOffset + position]) + 5L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        if (selectedPositionsCount == 0) {
            return 0L;
        }
        if (selectedPositionsCount == this.positionCount) {
            return this.getSizeInBytes();
        }
        long sizeInBytes = 0L;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            sizeInBytes += (long)(this.offsets[this.arrayOffset + i + 1] - this.offsets[this.arrayOffset + i]);
        }
        return sizeInBytes + 5L * (long)selectedPositionsCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : (long)this.getSliceLength(position);
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.slice, this.slice.getRetainedSize());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    public Slice getSlice(int position) {
        BlockUtil.checkReadablePosition(this, position);
        int offset = this.offsets[position + this.arrayOffset];
        int length = this.offsets[position + 1 + this.arrayOffset] - offset;
        return this.slice.slice(offset, length);
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean hasNull() {
        if (this.valueIsNull == null) {
            return false;
        }
        for (int i = 0; i < this.positionCount; ++i) {
            if (!this.valueIsNull[i + this.arrayOffset]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public VariableWidthBlock getSingleValueBlock(int position) {
        if (this.isNull(position)) {
            return new VariableWidthBlock(0, 1, Slices.EMPTY_SLICE, new int[]{0, 0}, new boolean[]{true});
        }
        int offset = this.getPositionOffset(position);
        int entrySize = this.getSliceLength(position);
        Slice copy = this.slice.copy(offset, entrySize);
        return new VariableWidthBlock(0, 1, copy, new int[]{0, copy.length()}, null);
    }

    @Override
    public VariableWidthBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (length == 0) {
            return new VariableWidthBlock(0, 0, Slices.EMPTY_SLICE, new int[1], null);
        }
        int[] newOffsets = new int[length + 1];
        int finalLength = 0;
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            newOffsets[i + 1] = finalLength += this.getSliceLength(position);
        }
        SliceOutput newSlice = Slices.allocate((int)finalLength).getOutput();
        boolean[] newValueIsNull = null;
        int firstPosition = positions[offset];
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
            newValueIsNull[0] = this.valueIsNull[firstPosition + this.arrayOffset];
        }
        int currentStart = this.getPositionOffset(firstPosition);
        int currentEnd = this.getPositionOffset(firstPosition + 1);
        for (int i = 1; i < length; ++i) {
            int currentOffset;
            int position = positions[offset + i];
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            if ((currentOffset = this.getPositionOffset(position)) != currentEnd) {
                newSlice.writeBytes(this.slice, currentStart, currentEnd - currentStart);
                currentStart = currentOffset;
            }
            currentEnd = this.getPositionOffset(position + 1);
        }
        newSlice.writeBytes(this.slice, currentStart, currentEnd - currentStart);
        return new VariableWidthBlock(0, length, newSlice.slice(), newOffsets, newValueIsNull);
    }

    @Override
    public VariableWidthBlock getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new VariableWidthBlock(positionOffset + this.arrayOffset, length, this.slice, this.offsets, this.valueIsNull);
    }

    @Override
    public VariableWidthBlock copyRegion(int positionOffset, int length) {
        boolean[] newValueIsNull;
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int[] newOffsets = BlockUtil.compactOffsets(this.offsets, positionOffset += this.arrayOffset, length);
        Slice newSlice = BlockUtil.compactSlice(this.slice, this.offsets[positionOffset], newOffsets[length]);
        boolean[] blArray = newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        if (newOffsets == this.offsets && newSlice == this.slice && newValueIsNull == this.valueIsNull) {
            return this;
        }
        return new VariableWidthBlock(0, length, newSlice, newOffsets, newValueIsNull);
    }

    @Override
    public VariableWidthBlock copyWithAppendedNull() {
        boolean[] newValueIsNull = BlockUtil.copyIsNullAndAppendNull(this.valueIsNull, this.arrayOffset, this.positionCount);
        int[] newOffsets = BlockUtil.copyOffsetsAndAppendNull(this.offsets, this.arrayOffset, this.positionCount);
        return new VariableWidthBlock(this.arrayOffset, this.positionCount + 1, this.slice, newOffsets, newValueIsNull);
    }

    int getRawArrayBase() {
        return this.arrayOffset;
    }

    int[] getRawOffsets() {
        return this.offsets;
    }

    boolean[] getRawValueIsNull() {
        return this.valueIsNull;
    }

    @Override
    public VariableWidthBlock getUnderlyingValueBlock() {
        return this;
    }

    public String toString() {
        return "VariableWidthBlock{positionCount=" + this.getPositionCount() + ", slice=" + String.valueOf(this.slice) + "}";
    }

    @Override
    public Optional<ByteArrayBlock> getNulls() {
        return BlockUtil.getNulls(this.valueIsNull, this.arrayOffset, this.positionCount);
    }
}

