/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SourcePage;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

final class PositionCountSourcePage
implements SourcePage {
    private int positionCount;

    PositionCountSourcePage(int positionCount) {
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return 0L;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return 0L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
    }

    @Override
    public int getChannelCount() {
        return 0;
    }

    @Override
    public Block getBlock(int channel) {
        throw new IllegalArgumentException("Page has no channels");
    }

    @Override
    public Page getPage() {
        return new Page(this.positionCount);
    }

    @Override
    public void selectPositions(int[] positions, int offset, int size) {
        if (size > this.positionCount) {
            throw new IllegalArgumentException("Page has no channels");
        }
        for (int i = 0; i < size; ++i) {
            Objects.checkIndex(offset + i, this.positionCount);
        }
        this.positionCount = size;
    }
}

