/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public abstract class AbstractLongType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(AbstractLongType.class, MethodHandles.lookup(), Long.TYPE);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);

    public AbstractLongType(TypeSignature signature) {
        super(signature, Long.TYPE, LongArrayBlock.class);
    }

    @Override
    public final int getFixedSize() {
        return 8;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public final long getLong(Block block, int position) {
        return AbstractLongType.read((LongArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public final void writeLong(BlockBuilder blockBuilder, long value) {
        ((LongArrayBlockBuilder)blockBuilder).writeLong(value);
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeLong(blockBuilder, this.getLong(block, position));
        }
    }

    @Override
    public int getFlatFixedSize() {
        return 8;
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 8));
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    public static long hash(long value) {
        return Long.rotateLeft(value * -4417276706812531889L, 31) * -7046029288634856825L;
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long read(@BlockPosition LongArrayBlock block, @BlockIndex int position) {
        return block.getLong(position);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, @FlatVariableOffset int unusedVariableSizeOffset) {
        return LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(long value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset, value);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        return AbstractLongType.hash(value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Long.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return left <= right;
    }
}

