/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public final class Fixed12Block
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Fixed12Block.class);
    public static final int FIXED12_BYTES = 12;
    public static final int SIZE_IN_BYTES_PER_POSITION = 13;
    private final int positionOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final int[] values;
    private final long retainedSizeInBytes;

    public Fixed12Block(int positionCount, Optional<boolean[]> valueIsNull, int[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    Fixed12Block(int positionOffset, int positionCount, boolean[] valueIsNull, int[] values) {
        if (positionOffset < 0) {
            throw new IllegalArgumentException("positionOffset is negative");
        }
        this.positionOffset = positionOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - positionOffset * 3 < positionCount * 3) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - positionOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((int[])values);
    }

    @Override
    public long getSizeInBytes() {
        return 13L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 13L * (long)length;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 12L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((int[])this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public int getInt(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        if (offset == 0) {
            return this.values[(position + this.positionOffset) * 3];
        }
        if (offset == 4) {
            return this.values[(position + this.positionOffset) * 3 + 1];
        }
        if (offset == 8) {
            return this.values[(position + this.positionOffset) * 3 + 2];
        }
        throw new IllegalArgumentException("offset must be 0, 4, or 8");
    }

    public long getFixed12First(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return Fixed12Block.decodeFixed12First(this.values, position + this.positionOffset);
    }

    public int getFixed12Second(int position) {
        return Fixed12Block.decodeFixed12Second(this.values, position + this.positionOffset);
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean hasNull() {
        if (this.valueIsNull == null) {
            return false;
        }
        for (int i = 0; i < this.positionCount; ++i) {
            if (!this.valueIsNull[i + this.positionOffset]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull != null && this.valueIsNull[position + this.positionOffset];
    }

    @Override
    public Fixed12Block getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        int index = (position + this.positionOffset) * 3;
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new Fixed12Block(0, 1, blArray, new int[]{this.values[index], this.values[index + 1], this.values[index + 2]});
    }

    @Override
    public Fixed12Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        int[] newValues = new int[length * 3];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.positionOffset];
            }
            int valuesIndex = (position + this.positionOffset) * 3;
            int newValuesIndex = i * 3;
            newValues[newValuesIndex] = this.values[valuesIndex];
            newValues[newValuesIndex + 1] = this.values[valuesIndex + 1];
            newValues[newValuesIndex + 2] = this.values[valuesIndex + 2];
        }
        return new Fixed12Block(0, length, newValueIsNull, newValues);
    }

    @Override
    public Fixed12Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new Fixed12Block(positionOffset + this.positionOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Fixed12Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.positionOffset, length);
        int[] newValues = BlockUtil.compactArray(this.values, positionOffset * 3, length * 3);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new Fixed12Block(0, length, newValueIsNull, newValues);
    }

    @Override
    public Fixed12Block copyWithAppendedNull() {
        boolean[] newValueIsNull = BlockUtil.copyIsNullAndAppendNull(this.valueIsNull, this.positionOffset, this.positionCount);
        int[] newValues = BlockUtil.ensureCapacity(this.values, (this.positionOffset + this.positionCount + 1) * 3);
        return new Fixed12Block(this.positionOffset, this.positionCount + 1, newValueIsNull, newValues);
    }

    @Override
    public Fixed12Block getUnderlyingValueBlock() {
        return this;
    }

    public String toString() {
        return "Fixed12Block{positionCount=" + this.getPositionCount() + "}";
    }

    @Override
    public Optional<ByteArrayBlock> getNulls() {
        return BlockUtil.getNulls(this.valueIsNull, this.positionOffset, this.positionCount);
    }

    public static void encodeFixed12(long first, int second, int[] values, int position) {
        int entryPosition = position * 3;
        values[entryPosition] = (int)first;
        values[entryPosition + 1] = (int)(first >>> 32);
        values[entryPosition + 2] = second;
    }

    public static long decodeFixed12First(int[] values, int position) {
        int offset = position * 3;
        long high32 = (long)values[offset + 1] << 32;
        long low32 = (long)values[offset] & 0xFFFFFFFFL;
        return high32 | low32;
    }

    public static int decodeFixed12Second(int[] values, int position) {
        int offset = position * 3;
        return values[offset + 2];
    }

    int getRawOffset() {
        return this.positionOffset;
    }

    @Nullable
    boolean[] getRawValueIsNull() {
        return this.valueIsNull;
    }

    int[] getRawValues() {
        return this.values;
    }
}

