/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import java.util.function.ObjLongConsumer;

public sealed interface Block
permits DictionaryBlock, RunLengthEncodedBlock, ValueBlock {
    public ValueBlock getSingleValueBlock(int var1);

    public int getPositionCount();

    public long getSizeInBytes();

    public long getRegionSizeInBytes(int var1, int var2);

    public long getRetainedSizeInBytes();

    public long getEstimatedDataSizeForStats(int var1);

    public void retainedBytesForEachPart(ObjLongConsumer<Object> var1);

    default public Block getPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        return DictionaryBlock.createInternal(offset, length, this, positions, DictionaryId.randomDictionaryId());
    }

    public Block copyPositions(int[] var1, int var2, int var3);

    public Block getRegion(int var1, int var2);

    public Block copyRegion(int var1, int var2);

    default public boolean mayHaveNull() {
        return true;
    }

    default public boolean hasNull() {
        for (int i = 0; i < this.getPositionCount(); ++i) {
            if (!this.isNull(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isNull(int var1);

    public Block copyWithAppendedNull();

    public ValueBlock getUnderlyingValueBlock();

    public int getUnderlyingValuePosition(int var1);
}

