/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public final class ByteArrayBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ByteArrayBlock.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 2;
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final byte[] values;
    private final long retainedSizeInBytes;

    public ByteArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, byte[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    ByteArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, byte[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((byte[])values);
    }

    public byte[] getRawValues() {
        return this.values;
    }

    public int getRawValuesOffset() {
        return this.arrayOffset;
    }

    @Override
    public long getSizeInBytes() {
        return 2L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 2L * (long)length;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 1L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((byte[])this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public byte getByte(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.values[position + this.arrayOffset];
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean hasNull() {
        if (this.valueIsNull == null) {
            return false;
        }
        for (int i = 0; i < this.positionCount; ++i) {
            if (!this.valueIsNull[i + this.arrayOffset]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public ByteArrayBlock getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new ByteArrayBlock(0, 1, blArray, new byte[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public ByteArrayBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean hasNull = false;
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        byte[] newValues = new byte[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (this.valueIsNull != null) {
                boolean isNull;
                newValueIsNull[i] = isNull = this.valueIsNull[position + this.arrayOffset];
                hasNull |= isNull;
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new ByteArrayBlock(0, length, (boolean[])(hasNull ? newValueIsNull : null), newValues);
    }

    @Override
    public ByteArrayBlock getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new ByteArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public ByteArrayBlock copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = BlockUtil.compactIsNull(this.valueIsNull, positionOffset += this.arrayOffset, length);
        byte[] newValues = BlockUtil.compactArray(this.values, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new ByteArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public ByteArrayBlock copyWithAppendedNull() {
        boolean[] newValueIsNull = BlockUtil.copyIsNullAndAppendNull(this.valueIsNull, this.arrayOffset, this.positionCount);
        byte[] newValues = BlockUtil.ensureCapacity(this.values, this.arrayOffset + this.positionCount + 1);
        return new ByteArrayBlock(this.arrayOffset, this.positionCount + 1, newValueIsNull, newValues);
    }

    @Override
    public ByteArrayBlock getUnderlyingValueBlock() {
        return this;
    }

    public String toString() {
        return "ByteArrayBlock{positionCount=" + this.getPositionCount() + "}";
    }

    @Override
    public Optional<ByteArrayBlock> getNulls() {
        return BlockUtil.getNulls(this.valueIsNull, this.arrayOffset, this.positionCount);
    }

    Slice getValuesSlice() {
        return Slices.wrappedBuffer((byte[])this.values, (int)this.arrayOffset, (int)this.positionCount);
    }

    boolean[] getRawValueIsNull() {
        return this.valueIsNull;
    }
}

