/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import java.util.Optional;

public class DuplicateMapKeyException
extends TrinoException {
    private final Block block;
    private final int position;
    private final boolean hasDetailedMessage;

    public DuplicateMapKeyException(Block block, int position) {
        this(block, position, Optional.empty());
    }

    private DuplicateMapKeyException(Block block, int position, Optional<String> detailedMessage) {
        super((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, detailedMessage.orElse("Duplicate map keys are not allowed"));
        this.block = block;
        this.position = position;
        this.hasDetailedMessage = detailedMessage.isPresent();
    }

    public DuplicateMapKeyException withDetailedMessage(Type keyType, ConnectorSession session) {
        if (this.hasDetailedMessage) {
            return this;
        }
        String detailedMessage = String.format("Duplicate map keys (%s) are not allowed", keyType.getObjectValue(this.block, this.position));
        return new DuplicateMapKeyException(this.block, this.position, Optional.of(detailedMessage));
    }
}

