/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public final class RowBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RowBlock.class);
    private final int startOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] rowIsNull;
    private final Block[] fieldBlocks;
    private volatile long sizeInBytes = -1L;
    private volatile long retainedSizeInBytes = -1L;

    public static RowBlock fromFieldBlocks(int positionCount, Block[] fieldBlocks) {
        return RowBlock.createRowBlockInternal(0, positionCount, null, fieldBlocks);
    }

    public static RowBlock fromNotNullSuppressedFieldBlocks(int positionCount, Optional<boolean[]> rowIsNullOptional, Block[] fieldBlocks) {
        if (rowIsNullOptional.isPresent()) {
            boolean[] rowIsNull = rowIsNullOptional.get();
            BlockUtil.checkArrayRange(rowIsNull, 0, positionCount);
            for (int fieldIndex = 0; fieldIndex < fieldBlocks.length; ++fieldIndex) {
                Block field = fieldBlocks[fieldIndex];
                for (int position = 0; position < positionCount; ++position) {
                    if (!rowIsNull[position] || field.isNull(position)) continue;
                    throw new IllegalArgumentException(String.format("Field value for null row must be null: field %s, position %s", fieldIndex, position));
                }
            }
        }
        return RowBlock.createRowBlockInternal(0, positionCount, rowIsNullOptional.orElse(null), fieldBlocks);
    }

    static RowBlock createRowBlockInternal(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, Block[] fieldBlocks) {
        return new RowBlock(startOffset, positionCount, rowIsNull, fieldBlocks);
    }

    private RowBlock(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, Block[] fieldBlocks) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("startOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (rowIsNull != null && rowIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("rowIsNull length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlocks, "fieldBlocks is null");
        if (fieldBlocks.length == 0) {
            throw new IllegalArgumentException("Row block must contain at least one field");
        }
        int firstFieldBlockPositionCount = fieldBlocks[0].getPositionCount();
        for (int i = 1; i < fieldBlocks.length; ++i) {
            if (firstFieldBlockPositionCount == fieldBlocks[i].getPositionCount()) continue;
            throw new IllegalArgumentException(String.format("length of field blocks differ: field 0: %s, block %s: %s", firstFieldBlockPositionCount, i, fieldBlocks[i].getPositionCount()));
        }
        if (firstFieldBlockPositionCount - startOffset < positionCount) {
            throw new IllegalArgumentException("fieldBlock length is less than positionCount");
        }
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.rowIsNull = positionCount == 0 ? null : rowIsNull;
        this.fieldBlocks = fieldBlocks;
    }

    public List<Block> getFieldBlocks() {
        if (this.startOffset == 0 && this.fieldBlocks[0].getPositionCount() == this.positionCount) {
            return List.of(this.fieldBlocks);
        }
        return Arrays.stream(this.fieldBlocks).map(block -> block.getRegion(this.startOffset, this.positionCount)).toList();
    }

    public Block getFieldBlock(int fieldIndex) {
        if (this.startOffset == 0 && this.fieldBlocks[fieldIndex].getPositionCount() == this.positionCount) {
            return this.fieldBlocks[fieldIndex];
        }
        return this.fieldBlocks[fieldIndex].getRegion(this.startOffset, this.positionCount);
    }

    public Block[] getRawFieldBlocks() {
        return this.fieldBlocks;
    }

    public Block getRawFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex];
    }

    public int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    public boolean mayHaveNull() {
        return this.rowIsNull != null;
    }

    @Override
    public boolean hasNull() {
        if (this.rowIsNull == null) {
            return false;
        }
        for (int i = 0; i < this.positionCount; ++i) {
            if (!this.rowIsNull[this.startOffset + i]) continue;
            return true;
        }
        return false;
    }

    @Nullable
    boolean[] getRawRowIsNull() {
        return this.rowIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes >= 0L) {
            return this.sizeInBytes;
        }
        long sizeInBytes = 1L * (long)this.positionCount;
        for (Block fieldBlock : this.fieldBlocks) {
            sizeInBytes += fieldBlock.getRegionSizeInBytes(this.startOffset, this.positionCount);
        }
        this.sizeInBytes = sizeInBytes;
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = this.retainedSizeInBytes;
        if (retainedSizeInBytes < 0L) {
            retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.fieldBlocks) + SizeOf.sizeOf((boolean[])this.rowIsNull);
            for (Block fieldBlock : this.fieldBlocks) {
                retainedSizeInBytes += fieldBlock.getRetainedSizeInBytes();
            }
            this.retainedSizeInBytes = retainedSizeInBytes;
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (Block fieldBlock : this.fieldBlocks) {
            consumer.accept(fieldBlock, fieldBlock.getRetainedSizeInBytes());
        }
        if (this.rowIsNull != null) {
            consumer.accept(this.rowIsNull, SizeOf.sizeOf((boolean[])this.rowIsNull));
        }
        consumer.accept(this.fieldBlocks, SizeOf.sizeOf((Object[])this.fieldBlocks));
        consumer.accept(this, INSTANCE_SIZE);
    }

    public String toString() {
        return String.format("RowBlock{startOffset=%d, fieldCount=%d, positionCount=%d}", this.startOffset, this.fieldBlocks.length, this.positionCount);
    }

    @Override
    public RowBlock copyWithAppendedNull() {
        boolean[] newRowIsNull = this.rowIsNull != null ? Arrays.copyOf(this.rowIsNull, this.startOffset + this.positionCount + 1) : new boolean[this.startOffset + this.positionCount + 1];
        newRowIsNull[this.startOffset + this.positionCount] = true;
        Block[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].copyWithAppendedNull();
        }
        return new RowBlock(this.startOffset, this.positionCount + 1, newRowIsNull, newBlocks);
    }

    @Override
    public RowBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        Block[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < newBlocks.length; ++i) {
            Block fieldBlock = this.fieldBlocks[i];
            if (this.startOffset != 0) {
                fieldBlock = fieldBlock.getRegion(this.startOffset, this.positionCount);
            }
            newBlocks[i] = fieldBlock.copyPositions(positions, offset, length);
        }
        boolean[] newRowIsNull = null;
        if (this.rowIsNull != null) {
            boolean hasNull = false;
            newRowIsNull = new boolean[length];
            for (int i = 0; i < length; ++i) {
                boolean isNull;
                newRowIsNull[i] = isNull = this.rowIsNull[this.startOffset + positions[offset + i]];
                hasNull |= isNull;
            }
            if (!hasNull) {
                newRowIsNull = null;
            }
        }
        return new RowBlock(0, length, newRowIsNull, newBlocks);
    }

    @Override
    public RowBlock getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return new RowBlock(this.startOffset + positionOffset, length, this.rowIsNull, this.fieldBlocks);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        BlockUtil.checkValidRegion(this.positionCount, position, length);
        long regionSizeInBytes = 1L * (long)length;
        for (Block fieldBlock : this.fieldBlocks) {
            regionSizeInBytes += fieldBlock.getRegionSizeInBytes(this.startOffset + position, length);
        }
        return regionSizeInBytes;
    }

    @Override
    public RowBlock copyRegion(int positionOffset, int length) {
        boolean[] newRowIsNull;
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        Object[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].copyRegion(this.startOffset + positionOffset, length);
        }
        boolean[] blArray = newRowIsNull = this.rowIsNull == null ? null : BlockUtil.compactArray(this.rowIsNull, this.startOffset + positionOffset, length);
        if (this.startOffset == 0 && newRowIsNull == this.rowIsNull && BlockUtil.arraySame(newBlocks, this.fieldBlocks)) {
            return this;
        }
        return new RowBlock(0, length, newRowIsNull, (Block[])newBlocks);
    }

    public SqlRow getRow(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            throw new IllegalStateException("Position is null");
        }
        return new SqlRow(this.startOffset + position, this.fieldBlocks);
    }

    @Override
    public RowBlock getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        Block[] newBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            newBlocks[i] = this.fieldBlocks[i].getSingleValueBlock(this.startOffset + position);
        }
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        boolean[] newRowIsNull = blArray;
        return new RowBlock(0, 1, newRowIsNull, newBlocks);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            return 0L;
        }
        long size = 0L;
        for (Block fieldBlock : this.fieldBlocks) {
            size += fieldBlock.getEstimatedDataSizeForStats(this.startOffset + position);
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.rowIsNull != null && this.rowIsNull[this.startOffset + position];
    }

    public static List<Block> getRowFieldsFromBlock(Block block) {
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
            RowBlock rowBlock = (RowBlock)runLengthEncodedBlock.getValue();
            return rowBlock.getFieldBlocks().stream().map(fieldBlock -> RunLengthEncodedBlock.create(fieldBlock, runLengthEncodedBlock.getPositionCount())).toList();
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            RowBlock rowBlock = (RowBlock)dictionaryBlock.getDictionary();
            return rowBlock.getFieldBlocks().stream().map(dictionaryBlock::createProjection).toList();
        }
        if (block instanceof RowBlock) {
            RowBlock rowBlock = (RowBlock)block;
            return rowBlock.getFieldBlocks();
        }
        throw new IllegalArgumentException("Unexpected block type: " + block.getClass().getSimpleName());
    }

    public static List<Block> getNullSuppressedRowFieldsFromBlock(Block block) {
        if (!block.mayHaveNull()) {
            return RowBlock.getRowFieldsFromBlock(block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
            RowBlock rowBlock = (RowBlock)runLengthEncodedBlock.getValue();
            if (!rowBlock.isNull(0)) {
                throw new IllegalStateException("Expected run length encoded block value to be null");
            }
            return rowBlock.getFieldBlocks().stream().map(fieldBlock -> fieldBlock.getRegion(0, 0)).toList();
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            int[] newIds = new int[dictionaryBlock.getPositionCount()];
            int idCount = 0;
            for (int position = 0; position < newIds.length; ++position) {
                if (dictionaryBlock.isNull(position)) continue;
                newIds[idCount] = dictionaryBlock.getId(position);
                ++idCount;
            }
            int nonNullPositionCount = idCount;
            RowBlock rowBlock = (RowBlock)dictionaryBlock.getDictionary();
            return rowBlock.getFieldBlocks().stream().map(field -> DictionaryBlock.create(nonNullPositionCount, field, newIds)).toList();
        }
        if (block instanceof RowBlock) {
            RowBlock rowBlock = (RowBlock)block;
            int[] nonNullPositions = new int[rowBlock.getPositionCount()];
            int idCount = 0;
            for (int position = 0; position < nonNullPositions.length; ++position) {
                if (rowBlock.isNull(position)) continue;
                nonNullPositions[idCount] = position;
                ++idCount;
            }
            int nonNullPositionCount = idCount;
            return rowBlock.getFieldBlocks().stream().map(field -> DictionaryBlock.create(nonNullPositionCount, field, nonNullPositions)).toList();
        }
        throw new IllegalArgumentException("Unexpected block type: " + block.getClass().getSimpleName());
    }

    @Override
    public RowBlock getUnderlyingValueBlock() {
        return this;
    }

    @Override
    public Optional<ByteArrayBlock> getNulls() {
        return BlockUtil.getNulls(this.rowIsNull, this.startOffset, this.positionCount);
    }
}

