/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.airlift.slice.SizeOf;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SourcePage;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

final class FixedSourcePage
implements SourcePage {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(FixedSourcePage.class);
    private Page page;

    FixedSourcePage(Page page) {
        Objects.requireNonNull(page, "page is null");
        this.page = page;
    }

    @Override
    public int getPositionCount() {
        return this.page.getPositionCount();
    }

    @Override
    public long getSizeInBytes() {
        return this.page.getSizeInBytes();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + this.page.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this, INSTANCE_SIZE);
        consumer.accept(this.page, Page.getInstanceSizeInBytes(this.page.getChannelCount()));
        for (int i = 0; i < this.page.getChannelCount(); ++i) {
            this.page.getBlock(i).retainedBytesForEachPart(consumer);
        }
    }

    @Override
    public int getChannelCount() {
        return this.page.getChannelCount();
    }

    @Override
    public Block getBlock(int channel) {
        return this.page.getBlock(channel);
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public Page getColumns(int[] channels) {
        return this.page.getColumns(channels);
    }

    @Override
    public void selectPositions(int[] positions, int offset, int size) {
        this.page = this.page.getPositions(positions, offset, size);
    }
}

