/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.Preconditions;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;
import java.util.Optional;

public record RelationCommentMetadata(SchemaTableName name, boolean tableRedirected, Optional<String> comment) {
    public RelationCommentMetadata {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(comment, "comment is null");
        Preconditions.checkArgument(!tableRedirected || comment.isEmpty(), "Unexpected comment for redirected table", new Object[0]);
    }

    public static RelationCommentMetadata forRelation(SchemaTableName name, Optional<String> comment) {
        return new RelationCommentMetadata(name, false, comment);
    }

    public static RelationCommentMetadata forRedirectedTable(SchemaTableName name) {
        return new RelationCommentMetadata(name, true, Optional.empty());
    }
}

