/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.FixedSourcePage;
import io.trino.spi.connector.PositionCountSourcePage;
import java.util.function.ObjLongConsumer;

public interface SourcePage {
    public static SourcePage create(int positionCount) {
        return new PositionCountSourcePage(positionCount);
    }

    public static SourcePage create(Block block) {
        return new FixedSourcePage(new Page(block.getPositionCount(), block));
    }

    public static SourcePage create(Page page) {
        return new FixedSourcePage(page);
    }

    public int getPositionCount();

    public long getSizeInBytes();

    public long getRetainedSizeInBytes();

    public void retainedBytesForEachPart(ObjLongConsumer<Object> var1);

    public int getChannelCount();

    public Block getBlock(int var1);

    public Page getPage();

    default public Page getColumns(int[] channels) {
        Block[] blocks = new Block[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            blocks[i] = this.getBlock(channels[i]);
        }
        return new Page(this.getPositionCount(), blocks);
    }

    public void selectPositions(int[] var1, int var2, int var3);
}

