/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Unstable;
import io.trino.spi.connector.CatalogVersion;
import io.trino.spi.metrics.Metrics;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class QueryInputMetadata {
    private final Optional<String> connectorName;
    private final String catalogName;
    private final CatalogVersion catalogVersion;
    private final String schema;
    private final String table;
    private final List<Column> columns;
    private final Optional<Object> connectorInfo;
    private final Metrics connectorMetrics;
    private final OptionalLong physicalInputBytes;
    private final OptionalLong physicalInputRows;

    @JsonCreator
    @Unstable
    public QueryInputMetadata(Optional<String> connectorName, String catalogName, CatalogVersion catalogVersion, String schema, String table, List<Column> columns, Optional<Object> connectorInfo, Metrics connectorMetrics, OptionalLong physicalInputBytes, OptionalLong physicalInputRows) {
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogVersion = Objects.requireNonNull(catalogVersion, "catalogVersion is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.connectorInfo = Objects.requireNonNull(connectorInfo, "connectorInfo is null");
        this.connectorMetrics = Objects.requireNonNull(connectorMetrics, "connectorMetrics is null");
        this.physicalInputBytes = Objects.requireNonNull(physicalInputBytes, "physicalInputBytes is null");
        this.physicalInputRows = Objects.requireNonNull(physicalInputRows, "physicalInputRows is null");
    }

    @JsonProperty
    public Optional<String> getConnectorName() {
        return this.connectorName;
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public CatalogVersion getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<Object> getConnectorInfo() {
        return this.connectorInfo;
    }

    @JsonProperty
    public Metrics getConnectorMetrics() {
        return this.connectorMetrics;
    }

    @JsonProperty
    public OptionalLong getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    @JsonProperty
    public OptionalLong getPhysicalInputRows() {
        return this.physicalInputRows;
    }

    public record Column(String name, String type) {
    }
}

