/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ScalarFunctionImplementation {
    private final MethodHandle methodHandle;
    private final Optional<MethodHandle> instanceFactory;
    private final List<Class<?>> lambdaInterfaces;

    private ScalarFunctionImplementation(MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, List<Class<?>> lambdaInterfaces) {
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
        this.lambdaInterfaces = List.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public Optional<MethodHandle> getInstanceFactory() {
        return this.instanceFactory;
    }

    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MethodHandle methodHandle;
        private MethodHandle instanceFactory;
        private List<Class<?>> lambdaInterfaces = List.of();

        private Builder() {
        }

        public Builder methodHandle(MethodHandle methodHandle) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            return this;
        }

        public Builder instanceFactory(MethodHandle instanceFactory) {
            this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
            return this;
        }

        public Builder lambdaInterfaces(List<Class<?>> lambdaInterfaces) {
            this.lambdaInterfaces = List.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
            return this;
        }

        public ScalarFunctionImplementation build() {
            return new ScalarFunctionImplementation(this.methodHandle, Optional.ofNullable(this.instanceFactory), this.lambdaInterfaces);
        }
    }
}

