/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class DescriptorArgument
extends Argument {
    public static final DescriptorArgument NULL_DESCRIPTOR = DescriptorArgument.builder().build();
    private final Optional<Descriptor> descriptor;

    @JsonCreator
    public DescriptorArgument(@JsonProperty(value="descriptor") Optional<Descriptor> descriptor) {
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        descriptor.ifPresent(descriptorValue -> Preconditions.checkArgument(descriptorValue.getFields().stream().allMatch(field -> field.getName().isPresent()), "All fields of a descriptor argument must have names"));
    }

    @JsonProperty
    public Optional<Descriptor> getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorArgument that = (DescriptorArgument)o;
        return this.descriptor.equals(that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.descriptor);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Descriptor descriptor;

        private Builder() {
        }

        public Builder descriptor(Descriptor descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        public DescriptorArgument build() {
            return new DescriptorArgument(Optional.ofNullable(this.descriptor));
        }
    }
}

