/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import io.trino.spi.function.table.ArgumentSpecification;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.Preconditions;

public class DescriptorArgumentSpecification
extends ArgumentSpecification {
    private DescriptorArgumentSpecification(String name, boolean required, Descriptor defaultValue) {
        super(name, required, defaultValue);
        Preconditions.checkArgument(defaultValue == null || defaultValue.getFields().stream().allMatch(field -> field.getName().isPresent()), "All fields of a descriptor argument must have names");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private boolean required = true;
        private Descriptor defaultValue;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder defaultValue(Descriptor defaultValue) {
            this.required = false;
            this.defaultValue = defaultValue;
            return this;
        }

        public DescriptorArgumentSpecification build() {
            return new DescriptorArgumentSpecification(this.name, this.required, this.defaultValue);
        }
    }
}

