/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import io.trino.spi.function.table.ArgumentSpecification;
import io.trino.spi.function.table.Preconditions;
import java.util.Objects;

public class TableArgumentSpecification
extends ArgumentSpecification {
    private final boolean rowSemantics;
    private final boolean pruneWhenEmpty;
    private final boolean passThroughColumns;

    private TableArgumentSpecification(String name, boolean rowSemantics, Boolean pruneWhenEmpty, boolean passThroughColumns) {
        super(name, true, null);
        Objects.requireNonNull(pruneWhenEmpty, "The pruneWhenEmpty property is not set");
        Preconditions.checkArgument(!rowSemantics || pruneWhenEmpty != false, "Cannot set the KEEP WHEN EMPTY property for a table argument with row semantics");
        this.rowSemantics = rowSemantics;
        this.pruneWhenEmpty = pruneWhenEmpty;
        this.passThroughColumns = passThroughColumns;
    }

    public boolean isRowSemantics() {
        return this.rowSemantics;
    }

    public boolean isPruneWhenEmpty() {
        return this.pruneWhenEmpty;
    }

    public boolean isPassThroughColumns() {
        return this.passThroughColumns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private boolean rowSemantics;
        private Boolean pruneWhenEmpty;
        private boolean passThroughColumns;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder rowSemantics() {
            this.rowSemantics = true;
            this.pruneWhenEmpty = true;
            return this;
        }

        public Builder pruneWhenEmpty() {
            this.pruneWhenEmpty = true;
            return this;
        }

        public Builder keepWhenEmpty() {
            this.pruneWhenEmpty = false;
            return this;
        }

        public Builder passThroughColumns() {
            this.passThroughColumns = true;
            return this;
        }

        public TableArgumentSpecification build() {
            return new TableArgumentSpecification(this.name, this.rowSemantics, this.pruneWhenEmpty, this.passThroughColumns);
        }
    }
}

