/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.trino.spi.block.Block;
import io.trino.spi.predicate.Primitives;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import jakarta.annotation.Nullable;

public final class Utils {
    static final TypeOperators TUPLE_DOMAIN_TYPE_OPERATORS = new TypeOperators();

    private Utils() {
    }

    public static Block nativeValueToBlock(Type type, @Nullable Object object) {
        Class<?> expectedClass;
        if (object != null && !(expectedClass = Primitives.wrap(type.getJavaType())).isInstance(object)) {
            throw new IllegalArgumentException(String.format("Object '%s' (%s) is not instance of %s", object, object.getClass().getName(), expectedClass.getName()));
        }
        return TypeUtils.writeNativeValue(type, object);
    }

    public static Object blockToNativeValue(Type type, Block block) {
        if (block.getPositionCount() != 1) {
            throw new IllegalArgumentException("Block should have exactly one position, but has: " + block.getPositionCount());
        }
        return TypeUtils.readNativeValue(type, block, 0);
    }

    static RuntimeException handleThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        return new RuntimeException(throwable);
    }
}

