/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.DoNotCall;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.statistics.ColumnStatisticType;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class ColumnStatisticMetadata {
    private final String columnName;
    private final String connectorAggregationId;
    private final Optional<ColumnStatisticType> statisticType;
    private final Optional<FunctionName> aggregation;

    public ColumnStatisticMetadata(String columnName, ColumnStatisticType statisticType) {
        this(columnName, statisticType.name(), statisticType);
    }

    public ColumnStatisticMetadata(String columnName, String connectorAggregationId, ColumnStatisticType statisticType) {
        this(columnName, connectorAggregationId, Optional.of(statisticType), Optional.empty());
    }

    public ColumnStatisticMetadata(String columnName, String connectorAggregationId, FunctionName aggregation) {
        this(columnName, connectorAggregationId, Optional.empty(), Optional.of(aggregation));
    }

    private ColumnStatisticMetadata(String columnName, String connectorAggregationId, Optional<ColumnStatisticType> statisticType, Optional<FunctionName> aggregation) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.connectorAggregationId = Objects.requireNonNull(connectorAggregationId, "connectorAggregationId is null");
        this.statisticType = Objects.requireNonNull(statisticType, "statisticType is null");
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
        if (statisticType.isPresent() == aggregation.isPresent()) {
            throw new IllegalArgumentException("Exactly one of statisticType and aggregation should be set");
        }
    }

    @JsonCreator
    @DoNotCall
    public static ColumnStatisticMetadata fromJson(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="connectorAggregationId") String connectorAggregationId, @JsonProperty(value="statisticType") Optional<ColumnStatisticType> statisticType, @JsonProperty(value="aggregation") Optional<FunctionName> aggregation) {
        return new ColumnStatisticMetadata(columnName, connectorAggregationId, statisticType, aggregation);
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public String getConnectorAggregationId() {
        return this.connectorAggregationId;
    }

    @JsonIgnore
    public ColumnStatisticType getStatisticType() {
        return this.statisticType.orElseThrow();
    }

    @JsonProperty(value="statisticType")
    public Optional<ColumnStatisticType> getStatisticTypeIfPresent() {
        return this.statisticType;
    }

    @JsonIgnore
    public FunctionName getAggregation() {
        return this.aggregation.orElseThrow();
    }

    @JsonProperty(value="aggregation")
    public Optional<FunctionName> getAggregationIfPresent() {
        return this.aggregation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatisticMetadata that = (ColumnStatisticMetadata)o;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.connectorAggregationId, that.connectorAggregationId) && Objects.equals(this.statisticType, that.statisticType) && Objects.equals(this.aggregation, that.aggregation);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.connectorAggregationId, this.statisticType, this.aggregation);
    }

    public String toString() {
        return new StringJoiner(", ", ColumnStatisticMetadata.class.getSimpleName() + "[", "]").add("columnName='" + this.columnName + "'").add("connectorAggregationId='" + this.connectorAggregationId + "'").add("statisticType=" + String.valueOf(this.statisticType)).add("aggregation=" + String.valueOf(this.aggregation)).toString();
    }
}

