/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Collections;
import java.util.List;

public class QuantileDigestType
extends AbstractVariableWidthType {
    private final Type valueType;

    @JsonCreator
    public QuantileDigestType(Type valueType) {
        super(new TypeSignature("qdigest", TypeSignatureParameter.typeParameter(valueType.getTypeSignature())), Slice.class);
        this.valueType = valueType;
    }

    @Override
    public Slice getSlice(Block block, int position) {
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        return valueBlock.getSlice(valuePosition);
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(value, offset, length);
    }

    @Override
    public Object getObjectValue(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlVarbinary(this.getSlice(block, position).getBytes());
    }

    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.singletonList(this.valueType);
    }
}

