/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RowFieldName;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class RowType
extends AbstractType {
    private static final InvocationConvention READ_FLAT_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.FLAT);
    private static final InvocationConvention READ_FLAT_TO_BLOCK_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationArgumentConvention.FLAT);
    private static final InvocationConvention WRITE_FLAT_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FLAT_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention EQUAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention HASH_CODE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention IDENTICAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
    private static final InvocationConvention INDETERMINATE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
    private static final InvocationConvention COMPARISON_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final MethodHandle READ_FLAT;
    private static final MethodHandle READ_FLAT_TO_BLOCK;
    private static final MethodHandle WRITE_FLAT;
    private static final MethodHandle EQUAL;
    private static final MethodHandle CHAIN_EQUAL;
    private static final MethodHandle HASH_CODE;
    private static final MethodHandle CHAIN_HASH_CODE;
    private static final MethodHandle IDENTICAL;
    private static final MethodHandle CHAIN_IDENTICAL_START;
    private static final MethodHandle CHAIN_IDENTICAL;
    private static final MethodHandle INDETERMINATE;
    private static final MethodHandle CHAIN_INDETERMINATE;
    private static final MethodHandle COMPARISON;
    private static final MethodHandle CHAIN_COMPARISON;
    private static final int MEGAMORPHIC_FIELD_COUNT = 64;
    private volatile TypeOperatorDeclaration typeOperatorDeclaration;
    private final List<Field> fields;
    private final List<Type> fieldTypes;
    private final boolean comparable;
    private final boolean orderable;
    private final int flatFixedSize;
    private final boolean flatVariableWidth;

    private RowType(TypeSignature typeSignature, List<Field> originalFields) {
        super(typeSignature, SqlRow.class, RowBlock.class);
        this.fields = List.copyOf(originalFields);
        this.fieldTypes = this.fields.stream().map(Field::getType).toList();
        this.comparable = this.fields.stream().allMatch(field -> field.getType().isComparable());
        this.orderable = this.fields.stream().allMatch(field -> field.getType().isOrderable());
        int fixedSize = this.fieldTypes.size();
        for (Type fieldType : this.fieldTypes) {
            fixedSize += fieldType.getFlatFixedSize();
        }
        this.flatFixedSize = fixedSize;
        this.flatVariableWidth = this.fields.stream().anyMatch(field -> field.getType().isFlatVariableWidth());
    }

    public static RowType from(List<Field> fields) {
        return new RowType(RowType.makeSignature(fields), fields);
    }

    public static RowType anonymous(List<Type> types) {
        List<Field> fields = types.stream().map(type -> new Field(Optional.empty(), (Type)type)).toList();
        return new RowType(RowType.makeSignature(fields), fields);
    }

    public static RowType rowType(Field ... field) {
        return RowType.from(Arrays.asList(field));
    }

    public static RowType anonymousRow(Type ... types) {
        return RowType.anonymous(Arrays.asList(types));
    }

    public static RowType createWithTypeSignature(TypeSignature typeSignature, List<Field> fields) {
        return new RowType(typeSignature, fields);
    }

    public static Field field(String name, Type type) {
        return new Field(Optional.of(name), type);
    }

    public static Field field(Type type) {
        return new Field(Optional.empty(), type);
    }

    private static TypeSignature makeSignature(List<Field> fields) {
        List<TypeSignatureParameter> parameters = fields.stream().map(field -> new NamedTypeSignature(field.getName().map(RowFieldName::new), field.getType().getTypeSignature())).map(TypeSignatureParameter::namedTypeParameter).toList();
        return new TypeSignature("row", parameters);
    }

    @Override
    public RowBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new RowBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries);
    }

    @Override
    public RowBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return new RowBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries);
    }

    @Override
    public String getDisplayName() {
        StringBuilder result = new StringBuilder();
        result.append("row").append('(');
        for (Field field : this.fields) {
            String typeDisplayName = field.getType().getDisplayName();
            if (field.getName().isPresent()) {
                result.append(field.getName().get()).append(' ').append(typeDisplayName);
            } else {
                result.append(typeDisplayName);
            }
            result.append(", ");
        }
        result.setLength(result.length() - 2);
        result.append(')');
        return result.toString();
    }

    @Override
    public Object getObjectValue(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        SqlRow sqlRow = this.getObject(block, position);
        ArrayList<Object> values = new ArrayList<Object>(sqlRow.getFieldCount());
        int rawIndex = sqlRow.getRawIndex();
        for (int i = 0; i < sqlRow.getFieldCount(); ++i) {
            values.add(this.fields.get(i).getType().getObjectValue(sqlRow.getRawFieldBlock(i), rawIndex));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeObject(blockBuilder, this.getObject(block, position));
        }
    }

    @Override
    public SqlRow getObject(Block block, int position) {
        return RowType.read((RowBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        SqlRow sqlRow = (SqlRow)value;
        int rawIndex = sqlRow.getRawIndex();
        ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> {
            for (int i = 0; i < sqlRow.getFieldCount(); ++i) {
                this.fields.get(i).getType().appendTo(sqlRow.getRawFieldBlock(i), rawIndex, (BlockBuilder)fieldBuilders.get(i));
            }
        });
    }

    @Override
    public int getFlatFixedSize() {
        return this.flatFixedSize;
    }

    @Override
    public boolean isFlatVariableWidth() {
        return this.flatVariableWidth;
    }

    @Override
    public int getFlatVariableWidthSize(Block block, int position) {
        if (!this.flatVariableWidth) {
            return 0;
        }
        SqlRow sqlRow = this.getObject(block, position);
        int rawIndex = sqlRow.getRawIndex();
        int variableSize = 0;
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            Type fieldType = this.fieldTypes.get(i);
            Block fieldBlock = sqlRow.getRawFieldBlock(i);
            if (fieldBlock.isNull(rawIndex)) continue;
            variableSize += fieldType.getFlatVariableWidthSize(fieldBlock, rawIndex);
        }
        return variableSize;
    }

    @Override
    public int getFlatVariableWidthLength(byte[] fixedSizeSlice, int fixedSizeOffset) {
        int variableSize = 0;
        for (Type fieldType : this.fieldTypes) {
            if (fixedSizeSlice[fixedSizeOffset] == 0) {
                variableSize += fieldType.getFlatVariableWidthLength(fixedSizeSlice, fixedSizeOffset + 1);
            }
            fixedSizeOffset += fieldType.getFlatFixedSize() + 1;
        }
        return variableSize;
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.fieldTypes;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public boolean isComparable() {
        return this.comparable;
    }

    @Override
    public boolean isOrderable() {
        return this.orderable;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration == null) {
            this.generateTypeOperators(typeOperators);
        }
        return this.typeOperatorDeclaration;
    }

    private void generateTypeOperators(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration != null) {
            return;
        }
        this.typeOperatorDeclaration = TypeOperatorDeclaration.builder(this.getJavaType()).addReadValueOperators(this.getReadValueOperatorMethodHandles(typeOperators)).addEqualOperators(RowType.getEqualOperatorMethodHandles(typeOperators, this.fields)).addHashCodeOperators(RowType.getHashCodeOperatorMethodHandles(typeOperators, this.fields)).addXxHash64Operators(RowType.getXxHash64OperatorMethodHandles(typeOperators, this.fields)).addIdenticalOperators(RowType.getIdenticalOperatorInvokers(typeOperators, this.fields)).addIndeterminateOperators(RowType.getIndeterminateOperatorInvokers(typeOperators, this.fields)).addComparisonUnorderedLastOperators(RowType.getComparisonOperatorInvokers(typeOperators::getComparisonUnorderedLastOperator, this.fields)).addComparisonUnorderedFirstOperators(RowType.getComparisonOperatorInvokers(typeOperators::getComparisonUnorderedFirstOperator, this.fields)).build();
    }

    private List<OperatorMethodHandle> getReadValueOperatorMethodHandles(TypeOperators typeOperators) {
        List<MethodHandle> fieldReadFlatMethods = this.fields.stream().map(Field::getType).map(type -> typeOperators.getReadValueOperator((Type)type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationArgumentConvention.FLAT))).toList();
        MethodHandle readFlat = MethodHandles.insertArguments(READ_FLAT, 0, this, fieldReadFlatMethods);
        MethodHandle readFlatToBlock = MethodHandles.insertArguments(READ_FLAT_TO_BLOCK, 0, this, fieldReadFlatMethods);
        List<MethodHandle> fieldWriteFlatMethods = this.fields.stream().map(Field::getType).map(type -> typeOperators.getReadValueOperator((Type)type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FLAT_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))).toList();
        MethodHandle writeFlat = MethodHandles.insertArguments(WRITE_FLAT, 0, this, fieldWriteFlatMethods);
        return List.of(new OperatorMethodHandle(READ_FLAT_CONVENTION, readFlat), new OperatorMethodHandle(READ_FLAT_TO_BLOCK_CONVENTION, readFlatToBlock), new OperatorMethodHandle(WRITE_FLAT_CONVENTION, writeFlat));
    }

    private static SqlRow read(RowBlock block, int position) {
        return block.getRow(position);
    }

    private static SqlRow megamorphicReadFlat(RowType rowType, List<MethodHandle> fieldReadFlatMethods, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) throws Throwable {
        return RowValueBuilder.buildRowValue(rowType, fieldBuilders -> RowType.readFlatFields(rowType, fieldReadFlatMethods, fixedSizeSlice, fixedSizeOffset, variableSizeSlice, variableSizeOffset, fieldBuilders));
    }

    private static void megamorphicReadFlatToBlock(RowType rowType, List<MethodHandle> fieldReadFlatMethods, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset, BlockBuilder blockBuilder) throws Throwable {
        ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> RowType.readFlatFields(rowType, fieldReadFlatMethods, fixedSizeSlice, fixedSizeOffset, variableSizeSlice, variableSizeOffset, fieldBuilders));
    }

    private static void readFlatFields(RowType rowType, List<MethodHandle> fieldReadFlatMethods, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset, List<BlockBuilder> fieldBuilders) throws Throwable {
        List<Type> fieldTypes = rowType.getTypeParameters();
        for (int fieldIndex = 0; fieldIndex < fieldTypes.size(); ++fieldIndex) {
            boolean isNull;
            Type fieldType = fieldTypes.get(fieldIndex);
            BlockBuilder fieldBuilder = fieldBuilders.get(fieldIndex);
            boolean bl = isNull = fixedSizeSlice[fixedSizeOffset] != 0;
            if (isNull) {
                fieldBuilder.appendNull();
            } else {
                fieldReadFlatMethods.get(fieldIndex).invokeExact(fixedSizeSlice, fixedSizeOffset + 1, variableSizeSlice, variableSizeOffset, fieldBuilder);
                if (fieldType.isFlatVariableWidth()) {
                    variableSizeOffset += fieldType.getFlatVariableWidthLength(fixedSizeSlice, fixedSizeOffset + 1);
                }
            }
            fixedSizeOffset += 1 + fieldType.getFlatFixedSize();
        }
    }

    private static void megamorphicWriteFlat(RowType rowType, List<MethodHandle> fieldWriteFlatMethods, SqlRow row, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) throws Throwable {
        int rawIndex = row.getRawIndex();
        List<Type> fieldTypes = rowType.getTypeParameters();
        for (int fieldIndex = 0; fieldIndex < fieldTypes.size(); ++fieldIndex) {
            Type fieldType = fieldTypes.get(fieldIndex);
            Block fieldBlock = row.getRawFieldBlock(fieldIndex);
            if (fieldBlock.isNull(rawIndex)) {
                fixedSizeSlice[fixedSizeOffset] = 1;
            } else {
                fieldWriteFlatMethods.get(fieldIndex).invokeExact(fieldBlock, rawIndex, fixedSizeSlice, fixedSizeOffset + 1, variableSizeSlice, variableSizeOffset);
                if (fieldType.isFlatVariableWidth()) {
                    variableSizeOffset += fieldType.getFlatVariableWidthLength(fixedSizeSlice, fixedSizeOffset + 1);
                }
            }
            fixedSizeOffset += 1 + fieldType.getFlatFixedSize();
        }
    }

    private static List<OperatorMethodHandle> getEqualOperatorMethodHandles(TypeOperators typeOperators, List<Field> fields) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            ArrayList<MethodHandle> equalOperators = new ArrayList<MethodHandle>();
            for (Field field2 : fields) {
                MethodHandle equalOperator = typeOperators.getEqualOperator(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
                equalOperators.add(equalOperator);
            }
            return Collections.singletonList(new OperatorMethodHandle(EQUAL_CONVENTION, EQUAL.bindTo(equalOperators)));
        }
        MethodHandle equal = MethodHandles.dropArguments(MethodHandles.constant(Boolean.class, Boolean.TRUE), 0, new Class[]{SqlRow.class, SqlRow.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field3 = fields.get(fieldId);
            equal = MethodHandles.collectArguments(CHAIN_EQUAL, 0, equal);
            MethodHandle fieldEqualOperator = typeOperators.getEqualOperator(field3.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
            equal = MethodHandles.insertArguments(equal, 2, fieldId, fieldEqualOperator);
            equal = MethodHandles.permuteArguments(equal, MethodType.methodType(Boolean.class, SqlRow.class, SqlRow.class), 0, 1, 0, 1);
        }
        return Collections.singletonList(new OperatorMethodHandle(EQUAL_CONVENTION, equal));
    }

    private static Boolean megamorphicEqualOperator(List<MethodHandle> equalOperators, SqlRow leftRow, SqlRow rightRow) throws Throwable {
        int leftRawIndex = leftRow.getRawIndex();
        int rightRawIndex = rightRow.getRawIndex();
        boolean unknown = false;
        for (int fieldIndex = 0; fieldIndex < equalOperators.size(); ++fieldIndex) {
            Block leftFieldBlock = leftRow.getRawFieldBlock(fieldIndex);
            Block rightFieldBlock = rightRow.getRawFieldBlock(fieldIndex);
            if (leftFieldBlock.isNull(leftRawIndex) || rightFieldBlock.isNull(rightRawIndex)) {
                unknown = true;
                continue;
            }
            MethodHandle equalOperator = equalOperators.get(fieldIndex);
            Boolean result = equalOperator.invokeExact(leftFieldBlock, leftRawIndex, rightFieldBlock, rightRawIndex);
            if (result == null) {
                unknown = true;
                continue;
            }
            if (result.booleanValue()) continue;
            return false;
        }
        if (unknown) {
            return null;
        }
        return true;
    }

    private static Boolean chainEqual(Boolean previousFieldsEqual, int currentFieldIndex, MethodHandle currentFieldEqual, SqlRow leftRow, SqlRow rightRow) throws Throwable {
        if (Boolean.FALSE.equals(previousFieldsEqual)) {
            return Boolean.FALSE;
        }
        int leftRawIndex = leftRow.getRawIndex();
        int rightRawIndex = rightRow.getRawIndex();
        Block leftFieldBlock = leftRow.getRawFieldBlock(currentFieldIndex);
        Block rightFieldBlock = rightRow.getRawFieldBlock(currentFieldIndex);
        if (leftFieldBlock.isNull(leftRawIndex) || rightFieldBlock.isNull(rightRawIndex)) {
            return null;
        }
        Boolean result = currentFieldEqual.invokeExact(leftFieldBlock, leftRawIndex, rightFieldBlock, rightRawIndex);
        if (Boolean.TRUE.equals(result)) {
            return previousFieldsEqual;
        }
        return result;
    }

    private static List<OperatorMethodHandle> getHashCodeOperatorMethodHandles(TypeOperators typeOperators, List<Field> fields) {
        return RowType.getHashCodeOperatorMethodHandles(fields, (Type type) -> typeOperators.getHashCodeOperator((Type)type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL)));
    }

    private static List<OperatorMethodHandle> getXxHash64OperatorMethodHandles(TypeOperators typeOperators, List<Field> fields) {
        return RowType.getHashCodeOperatorMethodHandles(fields, (Type type) -> typeOperators.getHashCodeOperator((Type)type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL)));
    }

    private static List<OperatorMethodHandle> getHashCodeOperatorMethodHandles(List<Field> fields, Function<Type, MethodHandle> getHashOperator) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List<MethodHandle> hashCodeOperators = fields.stream().map(field -> (MethodHandle)getHashOperator.apply(field.getType())).toList();
            return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(hashCodeOperators)));
        }
        MethodHandle hashCode = MethodHandles.dropArguments(MethodHandles.constant(Long.TYPE, 1), 0, new Class[]{SqlRow.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            hashCode = MethodHandles.collectArguments(CHAIN_HASH_CODE, 0, hashCode);
            MethodHandle fieldHashCodeOperator = getHashOperator.apply(field2.getType());
            hashCode = MethodHandles.insertArguments(hashCode, 1, fieldId, fieldHashCodeOperator);
            hashCode = MethodHandles.permuteArguments(hashCode, MethodType.methodType(Long.TYPE, SqlRow.class), 0, 0);
        }
        return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, hashCode));
    }

    private static long megamorphicHashCodeOperator(List<MethodHandle> hashCodeOperators, SqlRow row) throws Throwable {
        int rawIndex = row.getRawIndex();
        long result = 1L;
        for (int fieldIndex = 0; fieldIndex < hashCodeOperators.size(); ++fieldIndex) {
            Block fieldBlock = row.getRawFieldBlock(fieldIndex);
            long fieldHashCode = 0L;
            if (!fieldBlock.isNull(rawIndex)) {
                MethodHandle hashCodeOperator = hashCodeOperators.get(fieldIndex);
                fieldHashCode = hashCodeOperator.invokeExact(fieldBlock, rawIndex);
            }
            result = 31L * result + fieldHashCode;
        }
        return result;
    }

    private static long chainHashCode(long previousFieldHashCode, int currentFieldIndex, MethodHandle currentFieldHashCodeOperator, SqlRow row) throws Throwable {
        Block fieldBlock = row.getRawFieldBlock(currentFieldIndex);
        int rawIndex = row.getRawIndex();
        long fieldHashCode = 0L;
        if (!fieldBlock.isNull(rawIndex)) {
            fieldHashCode = currentFieldHashCodeOperator.invokeExact(fieldBlock, rawIndex);
        }
        return 31L * previousFieldHashCode + fieldHashCode;
    }

    private static List<OperatorMethodHandle> getIdenticalOperatorInvokers(TypeOperators typeOperators, List<Field> fields) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List<MethodHandle> identicalOperators = fields.stream().map(field -> typeOperators.getIdenticalOperator(field.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))).toList();
            return Collections.singletonList(new OperatorMethodHandle(IDENTICAL_CONVENTION, IDENTICAL.bindTo(identicalOperators)));
        }
        MethodHandle identical = MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, true), 0, new Class[]{SqlRow.class, SqlRow.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            identical = MethodHandles.collectArguments(CHAIN_IDENTICAL, 0, identical);
            MethodHandle fieldIdenticalOperator = typeOperators.getIdenticalOperator(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
            identical = MethodHandles.insertArguments(identical, 2, fieldId, fieldIdenticalOperator);
            identical = MethodHandles.permuteArguments(identical, MethodType.methodType(Boolean.TYPE, SqlRow.class, SqlRow.class), 0, 1, 0, 1);
        }
        identical = CHAIN_IDENTICAL_START.bindTo(identical);
        return Collections.singletonList(new OperatorMethodHandle(IDENTICAL_CONVENTION, identical));
    }

    private static boolean megamorphicIdenticalOperator(List<MethodHandle> identicalOperators, SqlRow leftRow, SqlRow rightRow) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftRow == null;
        boolean bl = rightIsNull = rightRow == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull == rightIsNull;
        }
        int leftRawIndex = leftRow.getRawIndex();
        int rightRawIndex = rightRow.getRawIndex();
        for (int fieldIndex = 0; fieldIndex < identicalOperators.size(); ++fieldIndex) {
            Block leftFieldBlock = leftRow.getRawFieldBlock(fieldIndex);
            Block rightFieldBlock = rightRow.getRawFieldBlock(fieldIndex);
            MethodHandle equalOperator = identicalOperators.get(fieldIndex);
            boolean result = equalOperator.invoke(leftFieldBlock, leftRawIndex, rightFieldBlock, rightRawIndex);
            if (result) continue;
            return false;
        }
        return true;
    }

    private static boolean chainIdenticalStart(MethodHandle chain, SqlRow leftRow, SqlRow rightRow) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftRow == null;
        boolean bl = rightIsNull = rightRow == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull == rightIsNull;
        }
        return chain.invokeExact(leftRow, rightRow);
    }

    private static boolean chainIdentical(boolean previousFieldsIdentical, int currentFieldIndex, MethodHandle currentFieldIdentical, SqlRow leftRow, SqlRow rightRow) throws Throwable {
        if (!previousFieldsIdentical) {
            return false;
        }
        return currentFieldIdentical.invokeExact(leftRow.getRawFieldBlock(currentFieldIndex), leftRow.getRawIndex(), rightRow.getRawFieldBlock(currentFieldIndex), rightRow.getRawIndex());
    }

    private static List<OperatorMethodHandle> getIndeterminateOperatorInvokers(TypeOperators typeOperators, List<Field> fields) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List<MethodHandle> indeterminateOperators = fields.stream().map(field -> typeOperators.getIndeterminateOperator(field.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL))).toList();
            return Collections.singletonList(new OperatorMethodHandle(INDETERMINATE_CONVENTION, INDETERMINATE.bindTo(indeterminateOperators)));
        }
        MethodHandle indeterminate = MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, false), 0, new Class[]{SqlRow.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            indeterminate = MethodHandles.collectArguments(CHAIN_INDETERMINATE, 0, indeterminate);
            MethodHandle fieldIndeterminateOperator = typeOperators.getIndeterminateOperator(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
            indeterminate = MethodHandles.insertArguments(indeterminate, 1, fieldId, fieldIndeterminateOperator);
            indeterminate = MethodHandles.permuteArguments(indeterminate, MethodType.methodType(Boolean.TYPE, SqlRow.class), 0, 0);
        }
        return Collections.singletonList(new OperatorMethodHandle(INDETERMINATE_CONVENTION, indeterminate));
    }

    private static boolean megamorphicIndeterminateOperator(List<MethodHandle> indeterminateOperators, SqlRow row) throws Throwable {
        if (row == null) {
            return true;
        }
        int rawIndex = row.getRawIndex();
        for (int fieldIndex = 0; fieldIndex < indeterminateOperators.size(); ++fieldIndex) {
            MethodHandle indeterminateOperator;
            Block fieldBlock = row.getRawFieldBlock(fieldIndex);
            if (fieldBlock.isNull(rawIndex) || !(indeterminateOperator = indeterminateOperators.get(fieldIndex)).invokeExact(fieldBlock, rawIndex)) continue;
            return true;
        }
        return false;
    }

    private static boolean chainIndeterminate(boolean previousFieldIndeterminate, int currentFieldIndex, MethodHandle currentFieldIndeterminateOperator, SqlRow row) throws Throwable {
        if (row == null || previousFieldIndeterminate) {
            return true;
        }
        int rawIndex = row.getRawIndex();
        Block fieldBlock = row.getRawFieldBlock(currentFieldIndex);
        if (fieldBlock.isNull(rawIndex)) {
            return true;
        }
        return currentFieldIndeterminateOperator.invokeExact(fieldBlock, rawIndex);
    }

    private static List<OperatorMethodHandle> getComparisonOperatorInvokers(BiFunction<Type, InvocationConvention, MethodHandle> comparisonOperatorFactory, List<Field> fields) {
        boolean orderable = fields.stream().allMatch(field -> field.getType().isOrderable());
        if (!orderable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List<MethodHandle> comparisonOperators = fields.stream().map(field -> (MethodHandle)comparisonOperatorFactory.apply(field.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL))).toList();
            return Collections.singletonList(new OperatorMethodHandle(COMPARISON_CONVENTION, COMPARISON.bindTo(comparisonOperators)));
        }
        MethodHandle comparison = MethodHandles.dropArguments(MethodHandles.constant(Long.TYPE, 0), 0, new Class[]{SqlRow.class, SqlRow.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            comparison = MethodHandles.collectArguments(CHAIN_COMPARISON, 0, comparison);
            MethodHandle fieldComparisonOperator = comparisonOperatorFactory.apply(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
            comparison = MethodHandles.insertArguments(comparison, 2, fieldId, fieldComparisonOperator);
            comparison = MethodHandles.permuteArguments(comparison, MethodType.methodType(Long.TYPE, SqlRow.class, SqlRow.class), 0, 1, 0, 1);
        }
        return Collections.singletonList(new OperatorMethodHandle(COMPARISON_CONVENTION, comparison));
    }

    private static long megamorphicComparisonOperator(List<MethodHandle> comparisonOperators, SqlRow leftRow, SqlRow rightRow) throws Throwable {
        int leftRawIndex = leftRow.getRawIndex();
        int rightRawIndex = rightRow.getRawIndex();
        for (int fieldIndex = 0; fieldIndex < comparisonOperators.size(); ++fieldIndex) {
            Block leftFieldBlock = leftRow.getRawFieldBlock(fieldIndex);
            Block rightFieldBlock = rightRow.getRawFieldBlock(fieldIndex);
            RowType.checkElementNotNull(leftFieldBlock.isNull(leftRawIndex));
            RowType.checkElementNotNull(rightFieldBlock.isNull(rightRawIndex));
            MethodHandle comparisonOperator = comparisonOperators.get(fieldIndex);
            long result = comparisonOperator.invoke(leftFieldBlock, leftRawIndex, rightFieldBlock, rightRawIndex);
            if (result != 0L) continue;
            return result;
        }
        return 0L;
    }

    private static long chainComparison(long previousFieldsResult, int fieldIndex, MethodHandle nextFieldComparison, SqlRow leftRow, SqlRow rightRow) throws Throwable {
        if (previousFieldsResult != 0L) {
            return previousFieldsResult;
        }
        int leftRawIndex = leftRow.getRawIndex();
        int rightRawIndex = rightRow.getRawIndex();
        Block leftFieldBlock = leftRow.getRawFieldBlock(fieldIndex);
        Block rightFieldBlock = rightRow.getRawFieldBlock(fieldIndex);
        RowType.checkElementNotNull(leftFieldBlock.isNull(leftRawIndex));
        RowType.checkElementNotNull(rightFieldBlock.isNull(rightRawIndex));
        return nextFieldComparison.invokeExact(leftFieldBlock, leftRawIndex, rightFieldBlock, rightRawIndex);
    }

    private static void checkElementNotNull(boolean isNull) {
        if (isNull) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for fields with null elements");
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            READ_FLAT = lookup.findStatic(RowType.class, "megamorphicReadFlat", MethodType.methodType(SqlRow.class, RowType.class, List.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE));
            READ_FLAT_TO_BLOCK = lookup.findStatic(RowType.class, "megamorphicReadFlatToBlock", MethodType.methodType(Void.TYPE, RowType.class, List.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, BlockBuilder.class));
            WRITE_FLAT = lookup.findStatic(RowType.class, "megamorphicWriteFlat", MethodType.methodType(Void.TYPE, RowType.class, List.class, SqlRow.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE));
            EQUAL = lookup.findStatic(RowType.class, "megamorphicEqualOperator", MethodType.methodType(Boolean.class, List.class, SqlRow.class, SqlRow.class));
            CHAIN_EQUAL = lookup.findStatic(RowType.class, "chainEqual", MethodType.methodType(Boolean.class, Boolean.class, Integer.TYPE, MethodHandle.class, SqlRow.class, SqlRow.class));
            HASH_CODE = lookup.findStatic(RowType.class, "megamorphicHashCodeOperator", MethodType.methodType(Long.TYPE, List.class, SqlRow.class));
            CHAIN_HASH_CODE = lookup.findStatic(RowType.class, "chainHashCode", MethodType.methodType(Long.TYPE, Long.TYPE, Integer.TYPE, MethodHandle.class, SqlRow.class));
            IDENTICAL = lookup.findStatic(RowType.class, "megamorphicIdenticalOperator", MethodType.methodType(Boolean.TYPE, List.class, SqlRow.class, SqlRow.class));
            CHAIN_IDENTICAL_START = lookup.findStatic(RowType.class, "chainIdenticalStart", MethodType.methodType(Boolean.TYPE, MethodHandle.class, SqlRow.class, SqlRow.class));
            CHAIN_IDENTICAL = lookup.findStatic(RowType.class, "chainIdentical", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Integer.TYPE, MethodHandle.class, SqlRow.class, SqlRow.class));
            INDETERMINATE = lookup.findStatic(RowType.class, "megamorphicIndeterminateOperator", MethodType.methodType(Boolean.TYPE, List.class, SqlRow.class));
            CHAIN_INDETERMINATE = lookup.findStatic(RowType.class, "chainIndeterminate", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Integer.TYPE, MethodHandle.class, SqlRow.class));
            COMPARISON = lookup.findStatic(RowType.class, "megamorphicComparisonOperator", MethodType.methodType(Long.TYPE, List.class, SqlRow.class, SqlRow.class));
            CHAIN_COMPARISON = lookup.findStatic(RowType.class, "chainComparison", MethodType.methodType(Long.TYPE, Long.TYPE, Integer.TYPE, MethodHandle.class, SqlRow.class, SqlRow.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Field {
        private final Type type;
        private final Optional<String> name;

        public Field(Optional<String> name, Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Type getType() {
            return this.type;
        }

        public Optional<String> getName() {
            return this.name;
        }
    }
}

