/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class PageBuilder {
    private static final int DEFAULT_INITIAL_EXPECTED_ENTRIES = 8;
    private final BlockBuilder[] blockBuilders;
    private PageBuilderStatus pageBuilderStatus;
    private int declaredPositions;

    public PageBuilder(List<? extends Type> types) {
        this(8, types);
    }

    public PageBuilder(int initialExpectedEntries, List<? extends Type> types) {
        this(initialExpectedEntries, 0x100000, types);
    }

    public static PageBuilder withMaxPageSize(int maxPageBytes, List<? extends Type> types) {
        return new PageBuilder(8, maxPageBytes, types);
    }

    private PageBuilder(int initialExpectedEntries, int maxPageBytes, List<? extends Type> types) {
        this.pageBuilderStatus = new PageBuilderStatus(maxPageBytes);
        this.blockBuilders = new BlockBuilder[types.size()];
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = types.get(i).createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), initialExpectedEntries);
        }
    }

    public void reset() {
        if (this.isEmpty()) {
            return;
        }
        this.pageBuilderStatus = new PageBuilderStatus(this.pageBuilderStatus.getMaxPageSizeInBytes());
        this.declaredPositions = 0;
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = this.blockBuilders[i].newBlockBuilderLike(this.pageBuilderStatus.createBlockBuilderStatus());
        }
    }

    public void resetTo(int position) {
        Objects.checkIndex(position, this.declaredPositions + 1);
        this.declaredPositions = position;
        for (BlockBuilder blockBuilder : this.blockBuilders) {
            blockBuilder.resetTo(position);
        }
    }

    public BlockBuilder getBlockBuilder(int channel) {
        return this.blockBuilders[channel];
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public void declarePositions(int positions) {
        this.declaredPositions += positions;
    }

    public boolean isFull() {
        return this.declaredPositions == Integer.MAX_VALUE || this.pageBuilderStatus.isFull();
    }

    public boolean isEmpty() {
        return this.declaredPositions == 0;
    }

    public int getPositionCount() {
        return this.declaredPositions;
    }

    public long getSizeInBytes() {
        return this.pageBuilderStatus.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = 0L;
        for (BlockBuilder blockBuilder : this.blockBuilders) {
            retainedSizeInBytes += blockBuilder.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    public Page build() {
        if (this.blockBuilders.length == 0) {
            return new Page(this.declaredPositions);
        }
        Block[] blocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blockBuilders[i].build();
            if (blocks[i].getPositionCount() == this.declaredPositions) continue;
            throw new IllegalStateException(String.format("Declared positions (%s) does not match block %s's number of entries (%s)", this.declaredPositions, i, blocks[i].getPositionCount()));
        }
        return Page.wrapBlocksWithoutCopy(this.declaredPositions, blocks);
    }
}

