/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.airlift.slice.SizeOf;
import java.util.List;
import java.util.Objects;

public record QueryId(String id) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(QueryId.class);

    public QueryId {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(!id.isEmpty(), "id is empty");
        QueryId.validateId(id);
    }

    @JsonCreator
    public static QueryId valueOf(String queryId) {
        return new QueryId(queryId);
    }

    @JsonValue
    @Deprecated
    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return this.id;
    }

    private static boolean isValidId(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidDottedId(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '_' || chars[i] == '.' || chars[i] >= 'a' && chars[i] <= 'z' || chars[i] >= '0' && chars[i] <= '9') continue;
            return false;
        }
        return true;
    }

    public static String validateId(String id) {
        if (!QueryId.isValidId(id)) {
            throw new IllegalArgumentException("Invalid queryId " + id);
        }
        return id;
    }

    public static List<String> parseDottedId(String id, int expectedParts, String name) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(expectedParts > 1, "expectedParts must be at least 2");
        Objects.requireNonNull(name, "name is null");
        char[] chars = id.toCharArray();
        if (!QueryId.isValidDottedId(chars)) {
            throw new IllegalArgumentException("Invalid " + name + " " + id);
        }
        String[] parts = new String[expectedParts];
        int startOffset = 0;
        int partIndex = 0;
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            if (chars[i] != '.') continue;
            if (i <= startOffset || i == length - 1) {
                throw new IllegalArgumentException("Invalid " + name + " " + id);
            }
            parts[partIndex++] = new String(chars, startOffset, i - startOffset);
            startOffset = i + 1;
        }
        parts[partIndex++] = new String(chars, startOffset, chars.length - startOffset);
        if (partIndex != expectedParts) {
            throw new IllegalArgumentException("Invalid " + name + " " + id);
        }
        return List.of(parts);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.id);
    }
}

