/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public interface BlockBuilder {
    public int getPositionCount();

    public long getSizeInBytes();

    public long getRetainedSizeInBytes();

    public void append(ValueBlock var1, int var2);

    public void appendRepeated(ValueBlock var1, int var2, int var3);

    public void appendRange(ValueBlock var1, int var2, int var3);

    public void appendPositions(ValueBlock var1, int[] var2, int var3, int var4);

    default public void appendBlockRange(Block rawBlock, int offset, int length) {
        Block block = rawBlock;
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RunLengthEncodedBlock.class, DictionaryBlock.class, ValueBlock.class}, (Block)block2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block2;
                this.appendRepeated(rleBlock.getValue(), 0, length);
                break;
            }
            case 1: {
                DictionaryBlock dictionaryBlock = (DictionaryBlock)block2;
                this.appendPositions(dictionaryBlock.getDictionary(), dictionaryBlock.getRawIds(), dictionaryBlock.getRawIdsOffset() + offset, length);
                break;
            }
            case 2: {
                ValueBlock valueBlock = (ValueBlock)block2;
                this.appendRange(valueBlock, offset, length);
            }
        }
    }

    public BlockBuilder appendNull();

    public void resetTo(int var1);

    public Block build();

    public ValueBlock buildValueBlock();

    public BlockBuilder newBlockBuilderLike(int var1, BlockBuilderStatus var2);

    default public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        return this.newBlockBuilderLike(BlockUtil.calculateBlockResetSize(this.getPositionCount()), blockBuilderStatus);
    }
}

