/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.EncoderUtil;
import java.util.Objects;

public class ByteArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "BYTE_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Block> getBlockClass() {
        return ByteArrayBlock.class;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        ByteArrayBlock byteArrayBlock = (ByteArrayBlock)block;
        int positionCount = byteArrayBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int rawOffset = byteArrayBlock.getRawValuesOffset();
        boolean[] isNull = byteArrayBlock.getRawValueIsNull();
        byte[] rawValues = byteArrayBlock.getRawValues();
        Objects.checkFromIndexSize(rawOffset, positionCount, rawValues.length);
        EncoderUtil.encodeNullsAsBits(sliceOutput, isNull, rawOffset, positionCount);
        if (isNull == null) {
            sliceOutput.writeBytes(rawValues, rawOffset, positionCount);
        } else {
            byte[] valuesWithoutNull = new byte[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = rawValues[i + rawOffset];
                nonNullPositionCount += isNull[i + rawOffset] ? 0 : 1;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeBytes(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public ByteArrayBlock readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int i;
        int positionCount = sliceInput.readInt();
        byte[] valueIsNullPacked = EncoderUtil.retrieveNullBits(sliceInput, positionCount);
        byte[] values = new byte[positionCount];
        if (valueIsNullPacked == null) {
            sliceInput.readBytes(Slices.wrappedBuffer((byte[])values));
            return new ByteArrayBlock(0, positionCount, null, values);
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(valueIsNullPacked, positionCount);
        int nonNullPositionCount = sliceInput.readInt();
        sliceInput.readBytes(Slices.wrappedBuffer((byte[])values, (int)0, (int)nonNullPositionCount));
        int position = nonNullPositionCount - 1;
        for (i = positionCount - 1; i >= (positionCount & 0xFFFFFFF8) && position >= 0; --i) {
            values[i] = values[position];
            if (valueIsNull[i]) continue;
            --position;
        }
        for (i = (positionCount & 0xFFFFFFF8) - 8; i >= 0 && position >= 0; i -= 8) {
            byte packed = valueIsNullPacked[i >>> 3];
            if (packed == 0) {
                System.arraycopy(values, position - 7, values, i, 8);
                position -= 8;
                continue;
            }
            if (packed == -1) continue;
            for (int j = i + 7; j >= i && position >= 0; --j) {
                values[j] = values[position];
                if (valueIsNull[j]) continue;
                --position;
            }
        }
        return new ByteArrayBlock(0, positionCount, valueIsNull, values);
    }
}

