/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Fixed12Block;
import java.util.Objects;

public class Fixed12BlockEncoding
implements BlockEncoding {
    public static final String NAME = "FIXED12";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Block> getBlockClass() {
        return Fixed12Block.class;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        Fixed12Block fixed12Block = (Fixed12Block)block;
        int positionCount = fixed12Block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int rawArrayOffset = fixed12Block.getRawOffset();
        boolean[] isNull = fixed12Block.getRawValueIsNull();
        int[] rawValues = fixed12Block.getRawValues();
        Objects.checkFromIndexSize(rawArrayOffset * 3, positionCount * 3, rawValues.length);
        EncoderUtil.encodeNullsAsBits(sliceOutput, isNull, rawArrayOffset, positionCount);
        if (isNull == null) {
            sliceOutput.writeInts(rawValues, rawArrayOffset * 3, positionCount * 3);
        } else {
            int[] valuesWithoutNull = new int[positionCount * 3];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                int rawIntOffset = (i + rawArrayOffset) * 3;
                valuesWithoutNull[nonNullPositionCount] = rawValues[rawIntOffset];
                valuesWithoutNull[nonNullPositionCount + 1] = rawValues[rawIntOffset + 1];
                valuesWithoutNull[nonNullPositionCount + 2] = rawValues[rawIntOffset + 2];
                nonNullPositionCount += isNull[i + rawArrayOffset] ? 0 : 3;
            }
            sliceOutput.writeInt(nonNullPositionCount / 3);
            sliceOutput.writeInts(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public Fixed12Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        int[] values = new int[positionCount * 3];
        if (valueIsNull == null) {
            sliceInput.readInts(values);
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readInts(values, 0, nonNullPositionCount * 3);
            int position = 3 * (nonNullPositionCount - 1);
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                System.arraycopy(values, position, values, 3 * i, 3);
                if (valueIsNull[i]) continue;
                position -= 3;
            }
        }
        return new Fixed12Block(0, positionCount, valueIsNull, values);
    }
}

