/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class IntArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IntArrayBlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new IntArrayBlock(0, 1, new boolean[]{true}, new int[1]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] values = new int[0];
    private long retainedSizeInBytes;

    public IntArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    public BlockBuilder writeInt(int value) {
        this.ensureCapacity(this.positionCount + 1);
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
        return this;
    }

    @Override
    public void append(ValueBlock block, int position) {
        this.ensureCapacity(this.positionCount + 1);
        IntArrayBlock intArrayBlock = (IntArrayBlock)block;
        if (intArrayBlock.isNull(position)) {
            this.valueIsNull[this.positionCount] = true;
            this.hasNullValue = true;
        } else {
            this.values[this.positionCount] = intArrayBlock.getInt(position);
            this.hasNonNullValue = true;
        }
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    @Override
    public void appendRepeated(ValueBlock block, int position, int count) {
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.append(block, position);
            return;
        }
        this.ensureCapacity(this.positionCount + count);
        IntArrayBlock intArrayBlock = (IntArrayBlock)block;
        if (intArrayBlock.isNull(position)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + count, true);
            this.hasNullValue = true;
        } else {
            int value = intArrayBlock.getInt(position);
            Arrays.fill(this.values, this.positionCount, this.positionCount + count, value);
            this.hasNonNullValue = true;
        }
        this.positionCount += count;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(count * 5);
        }
    }

    @Override
    public void appendRange(ValueBlock block, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, offset);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        IntArrayBlock intArrayBlock = (IntArrayBlock)block;
        int rawOffset = intArrayBlock.getRawValuesOffset();
        int[] rawValues = intArrayBlock.getRawValues();
        System.arraycopy(rawValues, rawOffset + offset, this.values, this.positionCount, length);
        boolean[] rawValueIsNull = intArrayBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                boolean isNull = rawValueIsNull[rawOffset + offset + i];
                this.hasNullValue |= isNull;
                this.hasNonNullValue |= !isNull;
                if (this.hasNullValue & this.hasNonNullValue) {
                    System.arraycopy(rawValueIsNull, rawOffset + offset + i, this.valueIsNull, this.positionCount + i, length - i);
                    break;
                }
                this.valueIsNull[this.positionCount + i] = isNull;
            }
        } else {
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 5);
        }
    }

    @Override
    public void appendPositions(ValueBlock block, int[] positions, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, positions[offset]);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        IntArrayBlock intArrayBlock = (IntArrayBlock)block;
        int rawOffset = intArrayBlock.getRawValuesOffset();
        int[] rawValues = intArrayBlock.getRawValues();
        boolean[] rawValueIsNull = intArrayBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                if (rawValueIsNull[rawPosition]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.values[this.positionCount + i] = rawValues[rawPosition];
                this.hasNonNullValue = true;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                this.values[this.positionCount + i] = rawValues[rawPosition];
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 5);
        }
    }

    @Override
    public BlockBuilder appendNull() {
        this.ensureCapacity(this.positionCount + 1);
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
        return this;
    }

    @Override
    public void resetTo(int position) {
        Objects.checkIndex(position, this.positionCount + 1);
        this.positionCount = position;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return this.buildValueBlock();
    }

    @Override
    public IntArrayBlock buildValueBlock() {
        return new IntArrayBlock(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new IntArrayBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.values.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(capacity);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateRetainedSize();
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public long getSizeInBytes() {
        return 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IntArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

