/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.IntArrayBlock;
import java.util.Objects;

public class IntArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Block> getBlockClass() {
        return IntArrayBlock.class;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        IntArrayBlock intArrayBlock = (IntArrayBlock)block;
        int positionCount = intArrayBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int rawOffset = intArrayBlock.getRawValuesOffset();
        boolean[] isNull = intArrayBlock.getRawValueIsNull();
        int[] rawValues = intArrayBlock.getRawValues();
        Objects.checkFromIndexSize(rawOffset, positionCount, rawValues.length);
        EncoderUtil.encodeNullsAsBits(sliceOutput, isNull, rawOffset, positionCount);
        if (isNull == null) {
            sliceOutput.writeInts(rawValues, rawOffset, positionCount);
        } else {
            int[] valuesWithoutNull = new int[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = rawValues[i + rawOffset];
                nonNullPositionCount += isNull[i + rawOffset] ? 0 : 1;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeInts(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public IntArrayBlock readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int i;
        int positionCount = sliceInput.readInt();
        byte[] valueIsNullPacked = EncoderUtil.retrieveNullBits(sliceInput, positionCount);
        int[] values = new int[positionCount];
        if (valueIsNullPacked == null) {
            sliceInput.readInts(values);
            return new IntArrayBlock(0, positionCount, null, values);
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(valueIsNullPacked, positionCount);
        int nonNullPositionCount = sliceInput.readInt();
        sliceInput.readInts(values, 0, nonNullPositionCount);
        int position = nonNullPositionCount - 1;
        for (i = positionCount - 1; i >= (positionCount & 0xFFFFFFF8) && position >= 0; --i) {
            values[i] = values[position];
            if (valueIsNull[i]) continue;
            --position;
        }
        for (i = (positionCount & 0xFFFFFFF8) - 8; i >= 0 && position >= 0; i -= 8) {
            byte packed = valueIsNullPacked[i >>> 3];
            if (packed == 0) {
                System.arraycopy(values, position - 7, values, i, 8);
                position -= 8;
                continue;
            }
            if (packed == -1) continue;
            for (int j = i + 7; j >= i && position >= 0; --j) {
                values[j] = values[position];
                if (valueIsNull[j]) continue;
                --position;
            }
        }
        return new IntArrayBlock(0, positionCount, valueIsNull, values);
    }
}

