/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.type.MapType;
import java.util.Optional;

public class MapBlockEncoding
implements BlockEncoding {
    public static final String NAME = "MAP";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Block> getBlockClass() {
        return MapBlock.class;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        MapBlock mapBlock = (MapBlock)block;
        int positionCount = mapBlock.getPositionCount();
        int offsetBase = mapBlock.getOffsetBase();
        int[] offsets = mapBlock.getOffsets();
        Optional<int[]> hashTable = mapBlock.getHashTables().tryGet();
        int entriesStartOffset = offsets[offsetBase];
        int entriesEndOffset = offsets[offsetBase + positionCount];
        blockEncodingSerde.writeType(sliceOutput, mapBlock.getMapType());
        blockEncodingSerde.writeBlock(sliceOutput, mapBlock.getRawKeyBlock().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        blockEncodingSerde.writeBlock(sliceOutput, mapBlock.getRawValueBlock().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        if (hashTable.isPresent()) {
            int hashTableLength = (entriesEndOffset - entriesStartOffset) * 2;
            sliceOutput.appendInt(hashTableLength);
            sliceOutput.writeInts(hashTable.get(), entriesStartOffset * 2, hashTableLength);
        } else {
            sliceOutput.appendInt(-1);
        }
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount + 1; ++position) {
            sliceOutput.writeInt(offsets[offsetBase + position] - entriesStartOffset);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, mapBlock.getRawMapIsNull(), offsetBase, positionCount);
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        MapType mapType = (MapType)blockEncodingSerde.readType(sliceInput);
        Block keyBlock = blockEncodingSerde.readBlock(sliceInput);
        Block valueBlock = blockEncodingSerde.readBlock(sliceInput);
        int hashTableLength = sliceInput.readInt();
        int[] hashTable = null;
        if (hashTableLength >= 0) {
            hashTable = new int[hashTableLength];
            sliceInput.readInts(hashTable);
        }
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("Deserialized MapBlock violates invariants: key %s, value %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        if (hashTable != null && keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized MapBlock violates invariants: expected hashtable size %s, actual hashtable size %s", keyBlock.getPositionCount() * 2, hashTable.length));
        }
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readInts(offsets);
        Optional<boolean[]> mapIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        MapHashTables hashTables = new MapHashTables(mapType, MapHashTables.HashBuildMode.DUPLICATE_NOT_CHECKED, positionCount, Optional.ofNullable(hashTable));
        return MapBlock.createMapBlockInternal(mapType, 0, positionCount, mapIsNull, offsets, keyBlock, valueBlock, hashTables);
    }
}

