/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.RowBlock;
import java.util.List;
import java.util.Optional;

public class RowBlockEncoding
implements BlockEncoding {
    public static final String NAME = "ROW";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Block> getBlockClass() {
        return RowBlock.class;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        RowBlock rowBlock = (RowBlock)block;
        sliceOutput.appendInt(rowBlock.getPositionCount());
        List<Block> fieldBlocks = rowBlock.getFieldBlocks();
        sliceOutput.appendInt(fieldBlocks.size());
        for (Block fieldBlock : fieldBlocks) {
            blockEncodingSerde.writeBlock(sliceOutput, fieldBlock);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, rowBlock.getRawRowIsNull(), rowBlock.getOffsetBase(), rowBlock.getPositionCount());
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int numFields = sliceInput.readInt();
        Block[] fieldBlocks = new Block[numFields];
        for (int i = 0; i < numFields; ++i) {
            fieldBlocks[i] = blockEncodingSerde.readBlock(sliceInput);
        }
        Optional<boolean[]> rowIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        return RowBlock.fromNotNullSuppressedFieldBlocks(positionCount, rowIsNull, fieldBlocks);
    }
}

