/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public final class ShortArrayBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ShortArrayBlock.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 3;
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final short[] values;
    private final long retainedSizeInBytes;

    public ShortArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, short[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    ShortArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, short[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((short[])values);
    }

    @Override
    public long getSizeInBytes() {
        return 3L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 3L * (long)length;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 2L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((short[])this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public short getShort(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.values[position + this.arrayOffset];
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean hasNull() {
        if (this.valueIsNull == null) {
            return false;
        }
        for (int i = 0; i < this.positionCount; ++i) {
            if (!this.valueIsNull[i + this.arrayOffset]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public ShortArrayBlock getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new ShortArrayBlock(0, 1, blArray, new short[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public ShortArrayBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean hasNull = false;
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        short[] newValues = new short[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (this.valueIsNull != null) {
                boolean isNull;
                newValueIsNull[i] = isNull = this.valueIsNull[position + this.arrayOffset];
                hasNull |= isNull;
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new ShortArrayBlock(0, length, (boolean[])(hasNull ? newValueIsNull : null), newValues);
    }

    @Override
    public ShortArrayBlock getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new ShortArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public ShortArrayBlock copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = BlockUtil.compactIsNull(this.valueIsNull, positionOffset += this.arrayOffset, length);
        short[] newValues = BlockUtil.compactArray(this.values, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new ShortArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public ShortArrayBlock copyWithAppendedNull() {
        boolean[] newValueIsNull = BlockUtil.copyIsNullAndAppendNull(this.valueIsNull, this.arrayOffset, this.positionCount);
        short[] newValues = BlockUtil.ensureCapacity(this.values, this.arrayOffset + this.positionCount + 1);
        return new ShortArrayBlock(this.arrayOffset, this.positionCount + 1, newValueIsNull, newValues);
    }

    @Override
    public ShortArrayBlock getUnderlyingValueBlock() {
        return this;
    }

    public String toString() {
        return "ShortArrayBlock{positionCount=" + this.getPositionCount() + "}";
    }

    @Override
    public Optional<ByteArrayBlock> getNulls() {
        return BlockUtil.getNulls(this.valueIsNull, this.arrayOffset, this.positionCount);
    }

    int getRawValuesOffset() {
        return this.arrayOffset;
    }

    short[] getRawValues() {
        return this.values;
    }

    boolean[] getRawValueIsNull() {
        return this.valueIsNull;
    }
}

